package com.wangxiaolu.promotion.service.activity.temporary.impl;

import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityReportedDao;
import com.wangxiaolu.promotion.enums.activity.TemActApproveStatus;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityReportedDto;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityCoreService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2024-04-18 11
 * @describe :
 */
@Service
@Slf4j
public class TemporaryActivityCoreServiceImpl implements TemporaryActivityCoreService {

    @Autowired
    TemporaryActivityReportedDao temporaryActivityReportedDao;


    /**
     * 活动上报保存
     *
     * @return 生成id
     */
    @Override
    public long activityDataReportedSave(TemporaryActivityReportedDto temActDto) {
        temActDto.setApproveStatus(TemActApproveStatus.SUBMITTED);
        return temporaryActivityReportedDao.activityDataSave(temActDto);
    }
}
