package com.wangxiaolu.promotion.controller.activity.temporary;

import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityReportedDto;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-04-18 13
 * @describe : 促销员活动上报数据查询
 */
@Slf4j
@RestController
@RequestMapping("/activity/temporary/query")
public class TemporaryActivityQueryController {

    @Autowired
    TemporaryActivityQueryService temporaryActivityQueryService;

    /**
     * 根据促销员id查询所有任务
     * @return 所有任务 todo 之后改为分页
     */
    @GetMapping("/all/{id}")
    public List<TemporaryActivityReportedDto> findtemporaryIdActivityDataList(@PathVariable("id") @NotNull Long temporaryId) {
        List<TemporaryActivityReportedDto> dtos = temporaryActivityQueryService.findtemporaryIdActivityDataList(temporaryId);
        return dtos;
    }

    /**
     * 根据促销员id查询今日任务
     */
    @GetMapping("/today/{id}")
    public TemporaryActivityReportedDto findTemporaryTodayActivityData(@PathVariable("id") @NotNull Long temporaryId) {
        TemporaryActivityReportedDto dto = temporaryActivityQueryService.findtemporaryIdTodayActivityData(temporaryId);
        return dto;
    }

    /**
     * 根据任务id查询
     */
    @GetMapping("/{id}")
    public TemporaryActivityReportedDto findTemporaryActivityById(@PathVariable("id") @NotNull Long activityId){
        TemporaryActivityReportedDto dto = temporaryActivityQueryService.findTemporaryActivityById(activityId);
        return dto;
    }
}
