package com.wangxiaolu.promotion.domain.user.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.wangxiaolu.promotion.domain.activity.mapper.entity.TemporaryActivityReportedDO;
import com.wangxiaolu.promotion.domain.user.dao.TemporaryInfoDao;
import com.wangxiaolu.promotion.domain.user.mapper.TemporaryInfoMapper;
import com.wangxiaolu.promotion.domain.user.mapper.entity.TemporaryInfoDO;
import com.wangxiaolu.promotion.domain.user.wrapperQo.TemporaryWrapper;
import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityReportedDto;
import com.wangxiaolu.promotion.pojo.user.dto.WxTemporaryInfoDto;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-08 16
 * @describe :促销员-信息
 */
@Service
public class TemporaryInfoDaoImpl implements TemporaryInfoDao {

    @Autowired
    TemporaryInfoMapper temporaryInfoMapper;

    /**
     * 微信-小程序注册的促销员信息
     */
    @Override
    public int saveWxTemporaryInfo(WxTemporaryInfoDto temporaryDto){
        TemporaryInfoDO entity = new TemporaryInfoDO();
        BeanUtils.copyProperties(temporaryDto, entity);
        return temporaryInfoMapper.insert(entity);
    }

    @Override
    public WxTemporaryInfoDto getUnimportantData(String openId, String phone) {
        TemporaryWrapper tw = new TemporaryWrapper().setOpenId(openId).setPhone(phone);
        LambdaQueryWrapper<TemporaryInfoDO> doqwer = buildQueryList(tw);
        TemporaryInfoDO temDo = temporaryInfoMapper.selectOne(doqwer);
        return transitionDto(temDo);
    }

    @Override
    public WxTemporaryInfoDto selectOneById(Integer id) {
        TemporaryInfoDO temDo = temporaryInfoMapper.selectById(id);
        return transitionDto(temDo);
    }

    @Override
    public void findTemporaryInfoByEmployeeQcId(String employeeQcId, PageInfo pageInfo) {
        TemporaryWrapper tw = new TemporaryWrapper()
                .setChargerQcId(employeeQcId);
        LambdaQueryWrapper<TemporaryInfoDO> qw = buildQueryList(tw);
        List<TemporaryInfoDO> temporaryInfoDOS = temporaryInfoMapper.selectList(qw);
        pageInfo.setRecords(transitionDtos(temporaryInfoDOS));
    }

    private LambdaQueryWrapper<TemporaryInfoDO> buildQueryList(TemporaryWrapper tw){
        LambdaQueryWrapper<TemporaryInfoDO> queryWrapper = new LambdaQueryWrapper<>();
        if (StringUtils.isNotBlank(tw.getOpenId())){
            queryWrapper.eq(TemporaryInfoDO::getOpenId,tw.getOpenId());
        }
        if (StringUtils.isNotBlank(tw.getPhone())){
            queryWrapper.eq(TemporaryInfoDO::getPhone,tw.getPhone());
        }
        if (StringUtils.isNotBlank(tw.getChargerQcId())){
            queryWrapper.eq(TemporaryInfoDO::getChargerQcId,tw.getChargerQcId());
        }
        return queryWrapper;
    }

    /**
     * DO to DTO (单个对象)
     *
     * @param temDos DO对象List
     * @return DTO对象
     */
    private List<WxTemporaryInfoDto> transitionDtos(List<TemporaryInfoDO> temDos) {
        if (CollectionUtils.isEmpty(temDos)) {
            return new ArrayList<>();
        }

        List<WxTemporaryInfoDto> dtos = new ArrayList<>(temDos.size() * 2);
        for (TemporaryInfoDO temDo : temDos) {
            dtos.add(transitionDto(temDo));
        }
        return dtos;
    }

    /**
     * DO to DTO (单个对象)
     * @param temDo DO对象
     * @return DTO对象
     */
    private WxTemporaryInfoDto transitionDto(TemporaryInfoDO temDo){
        WxTemporaryInfoDto temporaryDto = null;
        if (!Objects.isNull(temDo)){
            temporaryDto = new WxTemporaryInfoDto();
            BeanUtils.copyProperties(temDo, temporaryDto);
        }
        return temporaryDto;
    }
}
