package com.wangxiaolu.promotion.domain.activity.mapper.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 
 * @TableName temporary_activity_market_cell
 */
@TableName(value ="temporary_activity_market_cell")
@Data
public class TemporaryActivityMarketCellDO implements Serializable {
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 关联—temporary_info表id
     */
    private Integer temporaryId;

    private Long activityReportedId;

    /**
     * 商品类型名称
     */
    private String className;

    /**
     * 商品唯一标识，来源第三方系统的唯一ID（ERP）
     */
    private String prdId;

    /**
     * 商品名称
     */
    private String prdName;

    /**
     * 卖出-袋
     */
    private Integer bag;

    /**
     * 卖出-箱
     */
    private Integer box;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建日期YYYY-MM-DD 
     */
    private String createDate;

    /**
     * 修改时间
     */
    private Date modifyTime;

    /**
     * 1:使用中；0：删除；
     */
    private Integer isDelete;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

}