package com.wangxiaolu.promotion.service.activity.employee.impl;

import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityReportedDao;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryActivityWrapper;
import com.wangxiaolu.promotion.enums.activity.TemActApproveStatus;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityReportedDto;
import com.wangxiaolu.promotion.service.activity.employee.EmployeeQueryTemActivityService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-05-30 11
 * @describe : 员工查询促销员活动上报信息
 */
@Service
@Slf4j
public class EmployeeQueryTemActivityServiceImpl implements EmployeeQueryTemActivityService{

    @Autowired
    TemporaryActivityReportedDao temporaryActivityReportedDao;

    @Override
    public List<TemporaryActivityReportedDto> getEmployeeApproveActivitys(String employeeQcId) {
        TemporaryActivityWrapper tw = new TemporaryActivityWrapper()
                .setApproverId(employeeQcId)
                .setNotApproveStatus(TemActApproveStatus.SUBMITTED.name());
        return temporaryActivityReportedDao.findListToEmployee(tw);
    }
}
