package com.wangxiaolu.promotion.domain.activityplanv2.dao.impl;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wangxiaolu.promotion.common.enums.StatusType;
import com.wangxiaolu.promotion.common.util.BeanUtils;
import com.wangxiaolu.promotion.common.util.DataUtils;
import com.wangxiaolu.promotion.domain.activityplanv2.dao.ActivityPlanInfoDao;
import com.wangxiaolu.promotion.domain.activityplanv2.mapper.ActivityPlanInfoMapper;
import com.wangxiaolu.promotion.domain.activityplanv2.mapper.entity.ActivityPlanInfoDo;
import com.wangxiaolu.promotion.domain.manage.wrapperQo.ActivityPlanInfoWrapper;
import com.wangxiaolu.promotion.exception.DataException;
import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.activity.manage.dto.ActivityPlanInfoDto;
import com.wangxiaolu.promotion.result.basedata.RCode;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.exceptions.PersistenceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-02-06 11
 * @describe :
 */
@Service
public class ActivityPlanInfoDaoImpl implements ActivityPlanInfoDao {

    @Autowired
    private ActivityPlanInfoMapper activityPlanInfoMapper;

    @Override
    public void saveList(JSONArray table, Long recordId) {
        try {
            activityPlanInfoMapper.saveList(table, recordId);
        } catch (PersistenceException e) {
            e.printStackTrace();
            throw new DataException(RCode.ACTIVITY_PLAN_REPETITION_ERROR);
        }
    }

    @Override
    public void page(PageInfo pageInfo, ActivityPlanInfoWrapper wrapper) {
        LambdaQueryWrapper<ActivityPlanInfoDo> qw = buildWrapper(wrapper);
        Page<ActivityPlanInfoDo> page = new Page<>(pageInfo.getPageNum(), pageInfo.getPageSize());
        Page<ActivityPlanInfoDo> doPage =  activityPlanInfoMapper.selectPage(page, qw);
        pageInfo.pageCovert(doPage);
        pageInfo.setRecords(doPage.getRecords());
    }

    @Override
    public ActivityPlanInfoDto selectPlan(String storeCode, Date date) {
        ActivityPlanInfoDo activityPlanInfoDo = activityPlanInfoMapper.selectPlan(storeCode, date);
        return BeanUtils.transitionDto(activityPlanInfoDo, ActivityPlanInfoDto.class);
    }


    private LambdaQueryWrapper<ActivityPlanInfoDo> buildWrapper(ActivityPlanInfoWrapper wrapper) {
        LambdaQueryWrapper<ActivityPlanInfoDo> qw = new LambdaQueryWrapper<>();
        if (Objects.nonNull(wrapper.getEmployeeId())) {
            qw.eq(ActivityPlanInfoDo::getEmployeeId, wrapper.getEmployeeId());
        }

        if (Objects.nonNull(wrapper.getActivityPlanRecordId())) {
            qw.eq(ActivityPlanInfoDo::getPlanFileId, wrapper.getActivityPlanRecordId());
        }

        if (StringUtils.isNotBlank(wrapper.getDealerName())) {
            qw.like(ActivityPlanInfoDo::getDealerName, wrapper.getDealerName());
        }

        if (StringUtils.isNotBlank(wrapper.getCity())) {
            qw.like(ActivityPlanInfoDo::getCity, wrapper.getCity());
        }

        if (StringUtils.isNotBlank(wrapper.getStoreNameLike())) {
            qw.like(ActivityPlanInfoDo::getStoreName, wrapper.getStoreNameLike());
        }

        if (StringUtils.isNotBlank(wrapper.getStoreName())) {
            qw.eq(ActivityPlanInfoDo::getStoreName, wrapper.getStoreName());
        }

        if (Objects.nonNull(wrapper.getActivityStatus())) {
            qw.eq(ActivityPlanInfoDo::getPlanStatus, wrapper.getActivityStatus().getType());
        }

        qw.between(ActivityPlanInfoDo::getDate, wrapper.getActivityStartDate(), wrapper.getActivityEndDate());
        qw.eq(ActivityPlanInfoDo::getIsDelete, StatusType.VALID.getType());
        qw.orderByDesc(ActivityPlanInfoDo::getCreateTime);
        return qw;
    }


}
