package com.wangxiaolu.promotion.domain.manage.dao.impl;

import com.wangxiaolu.promotion.domain.manage.dao.TemporaryActivityTypeDao;
import com.wangxiaolu.promotion.domain.manage.mapper.TemporaryActivityTypeMapper;
import com.wangxiaolu.promotion.domain.manage.mapper.entity.TemporaryActivityTypeDO;
import com.wangxiaolu.promotion.enums.activity.ActivityType;
import com.wangxiaolu.promotion.pojo.activity.manage.dto.TemporaryActivityTypeDto;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @author : liqiulin
 * @date : 2024-09-10 11
 * @describe :
 */
@Service
public class TemporaryActivityTypeDaoImpl implements TemporaryActivityTypeDao {

    @Autowired
    TemporaryActivityTypeMapper temporaryActivityTypeMapper;

    @Override
    public List<TemporaryActivityTypeDto> selectPatternMap() {
        Integer type = ActivityType.pattern.getType();
        List<TemporaryActivityTypeDO> typeDos = temporaryActivityTypeMapper.selectPatternList(type);
        return transitionDtos(typeDos);
    }



    /**
     * DO to DTO (单个对象)
     *
     * @param dos DO对象List
     * @return DTO对象
     */
    private List<TemporaryActivityTypeDto> transitionDtos(List<TemporaryActivityTypeDO> dos) {
        if (CollectionUtils.isEmpty(dos)) {
            return new ArrayList<>();
        }

        List<TemporaryActivityTypeDto> dtos = new ArrayList<>(dos.size() * 2);
        for (TemporaryActivityTypeDO typeDO : dos) {
            dtos.add(transitionDto(typeDO));
        }
        return dtos;
    }

    private TemporaryActivityTypeDto transitionDto(TemporaryActivityTypeDO typeDO) {
        TemporaryActivityTypeDto dto = null;
        if (Objects.isNull(typeDO)) {
            return dto;
        }
        dto = new TemporaryActivityTypeDto();
        BeanUtils.copyProperties(typeDO, dto);
        return dto;
    }
    
}
