package com.wangxiaolu.promotion.controller.activityplanv2;

import com.alibaba.fastjson2.JSONObject;
import com.wangxiaolu.promotion.common.excel.FileUtils;
import com.wangxiaolu.promotion.exception.DataException;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.activity.manage.vo.ActivityPlanVo;
import com.wangxiaolu.promotion.pojo.activity.manage.vo.ManageEmployeeVo;
import com.wangxiaolu.promotion.pojo.activity.planv2.vo.ActivityPlanOperVo;
import com.wangxiaolu.promotion.pojo.user.dto.ManageEmployeeInfoDto;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.activityplanv2.PromPlanCoreService;
import com.wangxiaolu.promotion.service.user.ManageEmployeeQueryService;
import io.jsonwebtoken.lang.Collections;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Map;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2025-01-07 13
 * @describe :
 */
@Slf4j
@RestController
@RequestMapping("/plan/v2/core")
public class PromPlanCoreController {

    @Autowired
    private PromPlanCoreService promPlanCoreService;
    @Autowired
    private ManageEmployeeQueryService manageEmployeeQueryService;


    /**
     * 城市经理 - 上传计划（新增）
     * 当月只能上传次月的新增（当月需要新增需要交由职能角色上传）
     */
    @PostMapping("/self/upload")
    public R selfPlan(@RequestBody ActivityPlanVo activityPlanVo) {
        // 判断当前账号是否是城市经理
        boolean isSelf = manageEmployeeQueryService.isOneSelf(activityPlanVo.getEmployeeNo());
        // todo 当前时间不可新增
        if (isSelf) {
            throw new ParamException(RCode.FUNCTION_RESTRICT_ERROR);
        }

        if (!isSelf) {
            throw new DataException(RCode.EMP_PRIVILEGE_ERROR);
        }else {
            ManageEmployeeInfoDto one = manageEmployeeQueryService.findOne(new ManageEmployeeVo().setEmployeeNo(activityPlanVo.getEmployeeNo()));
            activityPlanVo.setEmployeeId(one.getId())
                    .setEmployeeName(one.getName())
                    .setDeptQcId(one.getDeptQcId())
                    .setDeptQcName(one.getDeptQcName());
        }

        try {
            String[] urlArr = activityPlanVo.getExcelUrl().split("/");
            String fileId = urlArr[urlArr.length - 1];
            String filePath = "/root/promotion/planv2/" + fileId;
            FileUtils.downloadExcel(activityPlanVo.getExcelUrl(), filePath);
            activityPlanVo.setExcelId(fileId);
            Map<String, Object> map = promPlanCoreService.selfPlanUp(activityPlanVo, filePath);
            return R.success(map);
        } catch (DataException e) {
            log.error(JSONObject.toJSONString(activityPlanVo));
            log.error(e.toString());
            return new R(e.getCode(), e.getMsg(), null);
        } catch (Exception e) {
            log.error(JSONObject.toJSONString(activityPlanVo));
            log.error(e.toString());
            return R.fail(e.getMessage());
        }
    }


    /**
     * 职能角色 - 上传计划（新增）
     */
    @PostMapping("/auth/upload")
    public R authPlan(@RequestBody ActivityPlanVo activityPlanVo) {
        boolean isAuth = manageEmployeeQueryService.isAuth(activityPlanVo.getEmployeeNo());
        if (!isAuth) {
            throw new DataException(RCode.EMP_PRIVILEGE_ERROR);
        }else {
            ManageEmployeeInfoDto one = manageEmployeeQueryService.findOne(new ManageEmployeeVo().setEmployeeNo(activityPlanVo.getEmployeeNo()));
            activityPlanVo.setEmployeeId(one.getId())
                    .setEmployeeName(one.getName())
                    .setDeptQcId(one.getDeptQcId())
                    .setDeptQcName(one.getDeptQcName());
        }
        try {
            String[] urlArr = activityPlanVo.getExcelUrl().split("/");
            String fileId = urlArr[urlArr.length - 1];
            String filePath = "/root/promotion/planv2/" + fileId;
            FileUtils.downloadExcel(activityPlanVo.getExcelUrl(), filePath);
            activityPlanVo.setExcelId(fileId);
            Map<String, Object> map = promPlanCoreService.authPlanUp(activityPlanVo, filePath);
            return R.success(map);
        } catch (DataException e) {
            log.error(JSONObject.toJSONString(activityPlanVo));
            log.error(e.toString());
            return new R(e.getCode(), e.getMsg(), null);
        } catch (Exception e) {
            log.error(JSONObject.toJSONString(activityPlanVo));
            log.error(e.toString());
            return R.fail(e.getMessage());
        }

    }

    /**
     * 确认上传（根据任一UUID）
     */
    @GetMapping("/upload/{uuid}")
    public R selfPlanAf(@PathVariable("uuid") String planUuid){
        promPlanCoreService.selfPlanAf(planUuid);
        return R.success();
    }

    /**
     * 促销计划修改
     */
    @PutMapping("/put")
    public R planPut(@RequestBody ActivityPlanVo activityPlanVo) {
        // 判断当前账号是否正常
        ManageEmployeeInfoDto one = manageEmployeeQueryService.findOne(new ManageEmployeeVo().setEmployeeNo(activityPlanVo.getEmployeeNo()));
        if (Objects.isNull(one)) {
            throw new DataException(RCode.EMP_PRIVILEGE_ERROR);
        }
        activityPlanVo.setEmployeeId(one.getId())
                .setEmployeeName(one.getName())
                .setDeptQcId(one.getDeptQcId())
                .setDeptQcName(one.getDeptQcName());
        try {
            String[] urlArr = activityPlanVo.getExcelUrl().split("/");
            String fileId = urlArr[urlArr.length - 1];
            String filePath = "/root/promotion/planv2/" + fileId;
            FileUtils.downloadExcel(activityPlanVo.getExcelUrl(), filePath);
            activityPlanVo.setExcelId(fileId);
            Map<String, Object> map = promPlanCoreService.selfPlanPut(activityPlanVo, filePath);
            return R.success(map);
        } catch (DataException e) {
            return new R(e.getCode(), e.getMsg(), null);
        } catch (Exception e) {
            return R.fail(e.getMessage());
        }
    }


    /**
     * 删除计划 计划日期大于今日可直接删除，如果计划日期是今日则必需是10点之前，包含过去日期不可删除
     */
    @DeleteMapping("/delete")
    public R deletePlan(@RequestBody ActivityPlanVo activityPlanVo){
        if (Collections.isEmpty(activityPlanVo.getPlanIds())){
            throw new ParamException(RCode.NEED_PARAM_ERROR);
        }

        // 判断当前账号是否是职能角色
        String employeeNo = activityPlanVo.getEmployeeNo();
        boolean isAuth = manageEmployeeQueryService.isAuth(employeeNo);
        if (isAuth) {
            employeeNo = "";
        }
        promPlanCoreService.deletePlan(activityPlanVo.getPlanIds(), employeeNo);
        return R.success();
    }

    @PostMapping("/save")
    public R saveWebActivityPlan(@RequestBody ActivityPlanOperVo operVo){
        boolean oneSelf = manageEmployeeQueryService.isOneSelf(operVo.getEmployeeNo());
        if (!oneSelf){
            throw new ParamException(RCode.ACTIVITY_PLAN_EMPLOYEE_ERROR);
        }
        // 操作人如果是城市经理的话，操作人与归属人必需一致
        boolean operIsSelf = manageEmployeeQueryService.isOneSelf(operVo.getOperNo());

        // todo 当前时间不可新增
        if (operIsSelf){
            throw new ParamException(RCode.FUNCTION_RESTRICT_ERROR);
        }

        if (operIsSelf && !operVo.getEmployeeNo().equals(operVo.getOperNo())){
            throw new ParamException(RCode.ACTIVITY_PLAN_EMPLOYEE_CREATE);
        }

        LocalDate localDate = operVo.getDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
//        LocalDate nextMonthValue = LocalDate.now().plusMonths(1);

//        if (operVo.getEmployeeNo().equals(operVo.getOperNo()) && (
//                !YearMonth.from(localDate).equals(YearMonth.from(nextMonthValue))
//        )) {
//            throw new ParamException(RCode.NEXT_MONTH_PLAN_CREATE_ERROR);
//        }
        // 上下班时间补充日期部分
        operVo.setClockInTime(LocalDateTime.of(localDate,operVo.getInTime()));
        operVo.setClockOutTime(LocalDateTime.of(localDate,operVo.getOutTime()));

        promPlanCoreService.saveActivityPlan(operVo);
        return R.success();
    }

    @PutMapping("/one")
    public R putActivityPlan(@RequestBody ActivityPlanOperVo operVo){
        if (Objects.isNull(operVo.getId())){
            throw new ParamException(RCode.NEED_PARAM_ERROR);
        }
        LocalDate localDate = operVo.getDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        // 上下班时间补充日期部分
        operVo.setClockInTime(LocalDateTime.of(localDate,operVo.getInTime()));
        operVo.setClockOutTime(LocalDateTime.of(localDate,operVo.getOutTime()));

        promPlanCoreService.putActivityPlan(operVo);
        return R.success();
    }

    @PutMapping("/more")
    public R putActivityPlans(@RequestBody ActivityPlanOperVo operVo){
        if (Objects.isNull(operVo.getEmployeeId()) || Collections.isEmpty(operVo.getPlanIds())){
            throw new ParamException(RCode.NEED_PARAM_ERROR);
        }
        promPlanCoreService.putActivityPlans(operVo);
        return R.success();
    }
}
