package com.wangxiaolu.promotion.service.activity.temporary.impl;

import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityReportedDao;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityReportedDto;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-04-18 13
 * @describe :
 */
@Service
@Slf4j
public class TemporaryActivityQueryServiceImpl implements TemporaryActivityQueryService {

    @Autowired
    TemporaryActivityReportedDao temporaryActivityReportedDao;

    /**
     * 根据促销员id查询所有任务
     */
    @Override
    public List<TemporaryActivityReportedDto> findtemporaryIdActivityDataList(Long temporaryId) {
        List<TemporaryActivityReportedDto> dtos = temporaryActivityReportedDao.findListByTemporaryId(temporaryId);
        return dtos;
    }


    /**
     * 根据促销员id查询今日任务
     */
    @Override
    public TemporaryActivityReportedDto findtemporaryIdTodayActivityData(Long temporaryId) {
        TemporaryActivityReportedDto dto = temporaryActivityReportedDao.findOneByCurrentDate(temporaryId);
        return dto;
    }

    @Override
    public TemporaryActivityReportedDto findTemporaryActivityById(Long activityId) {
        TemporaryActivityReportedDto dto = temporaryActivityReportedDao.findTemporaryActivityById(activityId);
        return dto;
    }
}
