package com.wangxiaolu.promotion.service.activity.temporary.impl;

import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityClockDao;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityReportedDao;
import com.wangxiaolu.promotion.enums.activity.TemActApproveStatus;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityReportedDto;
import com.wangxiaolu.promotion.pojo.user.dto.TemporaryClockDto;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityCoreService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-18 11
 * @describe :
 */
@Service
@Slf4j
public class TemporaryActivityCoreServiceImpl implements TemporaryActivityCoreService {

    @Autowired
    TemporaryActivityReportedDao temporaryActivityReportedDao;

    @Autowired
    TemporaryActivityClockDao temporaryActivityClockDao;


    /**
     * 活动上报保存
     * @return 生成id
     */
    @Override
    public long activityDataReportedSave(TemporaryActivityReportedDto temActDto) {
        temActDto.setApproveStatus(TemActApproveStatus.SUBMITTED);
        return temporaryActivityReportedDao.activityDataSave(temActDto);
    }

    /**
     * 促销员当日打卡信息保存
     */
    @Override
    public void clockInTodayActivity(TemporaryClockDto dto) {
        if (Objects.isNull(dto.getTemporaryClockId())){
            temporaryActivityClockDao.save(dto);
            return;
        }
        temporaryActivityClockDao.updateById(dto);
    }
}
