package com.wangxiaolu.promotion.domain.activity.dao.impl;

import cn.hutool.core.date.DateUtil;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityClockDao;
import com.wangxiaolu.promotion.domain.activity.mapper.TemporaryActivityClockMapper;
import com.wangxiaolu.promotion.domain.activity.mapper.entity.TemporaryActivityClockDO;
import com.wangxiaolu.promotion.pojo.user.dto.TemporaryClockDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2024-04-23 17
 * @describe :
 */
@Service
@Slf4j
public class TemporaryActivityClockDaoImpl implements TemporaryActivityClockDao {
    @Autowired
    TemporaryActivityClockMapper temporaryActivityClockMapper;

    @Override
    public void save(TemporaryClockDto dto) {
        TemporaryActivityClockDO clockDo = new TemporaryActivityClockDO();
        BeanUtils.copyProperties(dto,clockDo);
        clockDo.setCreateDate(DateUtil.today());
        temporaryActivityClockMapper.insert(clockDo);
    }

    @Override
    public void updateById(TemporaryClockDto dto) {
        TemporaryActivityClockDO clockDo = new TemporaryActivityClockDO();
        BeanUtils.copyProperties(dto,clockDo);
        clockDo.setId(dto.getTemporaryClockId());
        temporaryActivityClockMapper.updateById(clockDo);
    }
}
