package com.wangxiaolu.promotion.controller.activity.temporary;

import com.wangxiaolu.promotion.enums.activity.ClockType;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityReportedDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.vo.TemporaryActivityDataVo;
import com.wangxiaolu.promotion.pojo.user.dto.TemporaryClockDto;
import com.wangxiaolu.promotion.pojo.user.vo.TemporaryClockVo;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityCoreService;
import com.wangxiaolu.promotion.utils.DateUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-17 19
 * @describe : 促销员活动上报、修改
 */
@Slf4j
@RestController
@RequestMapping("/activity/temporary/core")
public class TemporaryActivityCoreController {

    @Autowired
    private TemporaryActivityCoreService tempActivityCoreService;

    /**
     * 促销员当日打卡信息保存
     */
    @PostMapping("/today/clock")
    public void clockInTodayActivity(@RequestBody @Validated TemporaryClockVo clockVo) {
        Integer clockType = clockVo.getClockType();
        boolean isClockIn = ClockType.TEMPORARY_CLOCK_IN.equals(clockType);
        // 上班卡必需有店铺id
        if (isClockIn && StringUtils.isBlank(clockVo.getStoreQcId())) {
            throw new ParamException(RCode.CLOCK_DETAIL_ERROR, null);
        }
        // 非上班卡必需有打卡记录ID
        if (!isClockIn && Objects.isNull((clockVo.getTemporaryClockId()))) {
            throw new ParamException(RCode.CLOCK_DETAIL_ERROR, null);
        }
        Date clockTime = new Date();

        TemporaryClockDto dto = new TemporaryClockDto(clockVo.getClockType(), clockVo.getTemporaryClockId(), clockVo.getTemporaryId(), clockVo.getTemporaryName());
        // 上班卡、午休下班卡、午休上班卡、下班卡
        if (isClockIn) {
            builderClockInData(clockVo, dto, clockTime);
        } else if (ClockType.TEMPORARY_NOON_CLOCK_OUT.equals(clockType)) {
            builderNoonClockOutData(clockVo, dto, clockTime);
        } else if (ClockType.TEMPORARY_NOON_CLOCK_IN.equals(clockType)) {
            builderNoonClockInData(clockVo, dto, clockTime);
        } else if (ClockType.TEMPORARY_CLOCK_OUT.equals(clockType)) {
            builderClockOutData(clockVo, dto, clockTime);
        }
        tempActivityCoreService.clockInTodayActivity(dto);
    }

    // 上班打卡
    private void builderClockInData(TemporaryClockVo clockVo, TemporaryClockDto clockDto, Date dateTime) {
//        todo if (!DateUtils.parseTime(new Date(), ClockType.TEMPORARY_CLOCK_IN_BEGIN_TIME, ClockType.TEMPORARY_CLOCK_IN_END_TIME)) {
//            throw new ParamException(RCode.CLOCK_DETAIL_TIME_ERROR, null);
//        }

        clockDto.setTemporaryId(clockVo.getTemporaryId())
                .setTemporaryName(clockVo.getTemporaryName())
                .setStoreQcId(clockVo.getStoreQcId())
                .setStoreName(clockVo.getStoreName())
                .setClockInAddress(clockVo.getClockAddress())
                .setClockInCoordinates(clockVo.getClockCoordinates())
                .setClockInPhoto(clockVo.getClockPhoto())
                .setClockInPhotoFieldId(clockVo.getClockPhotoFieldId())
                .setClockInTime(dateTime);
    }

    // 午休下班卡
    private void builderNoonClockOutData(TemporaryClockVo clockVo, TemporaryClockDto clockDto, Date dateTime) {
//       todo if (!DateUtils.parseTime(new Date(), ClockType.TEMPORARY_NOON_CLOCK_OUT_BEGIN_TIME, ClockType.TEMPORARY_NOON_CLOCK_OUT_END_TIME)) {
//            throw new ParamException(RCode.CLOCK_DETAIL_TIME_ERROR, null);
//        }
        clockDto.setTemporaryClockId(clockVo.getTemporaryClockId())
                .setNoonClockOutAddress(clockVo.getClockAddress())
                .setNoonClockOutCoordinates(clockVo.getClockCoordinates())
                .setNoonClockOutPhoto(clockVo.getClockPhoto())
                .setNoonClockOutPhotoFieldId(clockVo.getClockPhotoFieldId())
                .setNoonClockOutTime(dateTime);

    }

    // 午休上班卡
    private void builderNoonClockInData(TemporaryClockVo clockVo, TemporaryClockDto clockDto, Date dateTime) {
        if (!DateUtils.parseTime(new Date(), ClockType.TEMPORARY_NOON_CLOCK_IN_BEGIN_TIME, ClockType.TEMPORARY_NOON_CLOCK_IN_END_TIME)) {
            throw new ParamException(RCode.CLOCK_DETAIL_TIME_ERROR, null);
        }
        clockDto.setTemporaryClockId(clockVo.getTemporaryClockId())
                .setNoonClockInAddress(clockVo.getClockAddress())
                .setNoonClockInCoordinates(clockVo.getClockCoordinates())
                .setNoonClockInPhoto(clockVo.getClockPhoto())
                .setNoonClockInPhotoFieldId(clockVo.getClockPhotoFieldId())
                .setNoonClockInTime(dateTime);
    }

    // 下班卡
    private void builderClockOutData(TemporaryClockVo clockVo, TemporaryClockDto clockDto, Date dateTime) {
        if (!DateUtils.parseTime(new Date(), ClockType.TEMPORARY_CLOCK_OUT_BEGIN_TIME, ClockType.TEMPORARY_CLOCK_OUT_END_TIME)) {
            throw new ParamException(RCode.CLOCK_DETAIL_TIME_ERROR, null);
        }
        clockDto.setTemporaryClockId(clockVo.getTemporaryClockId())
                .setClockOutAddress(clockVo.getClockAddress())
                .setClockOutCoordinates(clockVo.getClockCoordinates())
                .setClockOutPhoto(clockVo.getClockPhoto())
                .setClockOutPhotoFieldId(clockVo.getClockPhotoFieldId())
                .setClockOutTime(dateTime);
    }


    /**
     * 促销员今日活动上报
     * 返回活动生成id
     */
    @PostMapping("/today/reported")
    public Long todayActivityDataReported(@RequestBody @Validated TemporaryActivityDataVo activityVo) {
        TemporaryActivityReportedDto temActDto = new TemporaryActivityReportedDto();
        BeanUtils.copyProperties(activityVo, temActDto);
        return tempActivityCoreService.activityDataReportedSave(temActDto);
    }


}
