package com.wangxiaolu.promotion.pojo.activity.temporary.dto;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 
 * @TableName temporary_activity_photo
 */
@Data
@Accessors(chain = true)
public class TemporaryActivityPhotoDto implements Serializable {
    /**
     * 主键id
     */
    private Long id;

    /**
     * temporary_info表id
     */
    private Integer temporaryId;

    /**
     * 活动上报ID，关联表temporary_activity_reported表主键id
     */
    private Long reportedId;

    /**
     * 促销员上班打卡记录ID，关联temporary_activity_clock表主键ID
     */
    private Long clockId;

    /**
     * 图片所属类别：1：推广试吃；2……
     */
    private Integer type;

    /**
     * 图片http地址
     */
    private String photoUrl;

    /**
     * 图片Id
     */
    private String photoFiledId;

    /**
     * 是否删除
     * 0:删除；1：可用
     */
    private Integer isDelete;

    /**
     * 图片的创建时间，只是用来前端显示，所以用varchar不timestamp
     */
    private Date updateTime;

    private static final long serialVersionUID = 1L;
}