package com.wangxiaolu.promotion.controller.activity.manage.activityplan;

import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.activity.manage.dto.EmployeeActivityPlanRecordDto;
import com.wangxiaolu.promotion.pojo.activity.manage.vo.ActivityPlanVo;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.service.activity.manage.ActivityPlanRecordQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author : liqiulin
 * @date : 2024-08-21 14
 * @describe :活动计划记录查询
 */
@Slf4j
@RestController
@RequestMapping("/activity/employee/plan/query")
public class ActivityPlanRecordQueryController {

    @Autowired
    ActivityPlanRecordQueryService activityPlanRecordQueryService;

    @PostMapping("/record/page")
    public R findActivityPlanRecordPage(@RequestBody PageInfo pageInfo){
        activityPlanRecordQueryService.findActivityPlanRecordPage(pageInfo);
        return R.success(pageInfo);
    }

    @PostMapping("/record/one")
    public R findActivityPlanRecord(@RequestBody ActivityPlanVo activityPlanVo){
        EmployeeActivityPlanRecordDto dto = activityPlanRecordQueryService.findActivityPlanRecord(activityPlanVo);
        return R.success(dto);
    }
}
