package com.wangxiaolu.promotion.domain.activity.mapper.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 *
 * @TableName temporary_activity_photo
 */
@TableName(value ="temporary_activity_photo")
@Data
@Accessors(chain = true)
public class TemporaryActivityPhotoDO implements Serializable {
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * temporary_info表id
     */
    private Integer temporaryId;

    /**
     * 活动上报ID，关联表temporary_activity_reported表主键id
     */
    private Long reportedId;

    /**
     * 促销员上班打卡记录ID，关联temporary_activity_clock表主键ID
     */
    private Long clockId;

    /**
     * 图片所属类别：1： 推广试吃照片 2推广互动照片 3:推广成交照片4:上班打卡图片 5: 午休下班打卡图片
     * 6:午休上班打卡图片 7: 下班打卡图片 8: 当日销量POS机页面凭证 9: 随机任务 10: POS照片
     *
     */
    private Integer type;

    /**
     * 图片http地址
     */
    private String photoUrl;

    /**
     * 图片Id
     */
    private String photoFiledId;

    /**
     * 是否删除
     * 0:删除；1：可用
     */
    private Integer isDelete;

    /**
     * 同一类型下的图片修改时间
     */
    private Date updateTime;

    private Date createTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}
