package com.wangxiaolu.promotion.utils;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import org.apache.commons.lang3.StringUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.*;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;

/**
 * @author : liqiulin
 * @date : 2024-04-23 15
 * @describe : 时间工具类
 */
public class DateUtils {
    /**
     * 判断时间是否是范围内
     * 入参时间格式："00:00:00"
     */
    public static boolean parseTime(Date date, String beginTime, String endTime) {
        try {
            String today = DateUtil.today();
            String format = DatePattern.NORM_DATETIME_PATTERN;
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            Date beginTimeD = sdf.parse(today + " " + beginTime);
            Date endTimeD = sdf.parse(today + " " + endTime);
            return DateUtil.isIn(date, beginTimeD, endTimeD);
        } catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static LocalTime parseLocalTimeByEmdtime(String emdtimeStr) {
        if (StringUtils.isBlank(emdtimeStr)) {
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss zzz yyyy", Locale.ENGLISH);
        return LocalTime.parse(emdtimeStr, formatter);
    }

    public static Date parseDateBylocalDate(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
        Instant instant = zonedDateTime.toInstant();
        return Date.from(instant);
    }

    public static Date parseDateByLocalTime(LocalTime localTime) {
        if (localTime == null) {
            return null;
        }
        // 1. 获取当前日期（可替换为任意日期）
        LocalDate today = LocalDate.now();

        // 2. 组合成 LocalDateTime
        LocalDateTime localDateTime = today.atTime(localTime);

        // 3. 指定时区（示例：系统默认时区）
        ZoneId zoneId = ZoneId.systemDefault(); // 或 ZoneId.of("UTC")
        ZonedDateTime zonedDateTime = localDateTime.atZone(zoneId);

        // 4. 转换为 Date
        Date date = Date.from(zonedDateTime.toInstant());

        // 输出结果
        System.out.println("LocalTime: " + localTime);
        System.out.println("Date: " + date);

        return date;

    }


    public static LocalDate parseDateBylocalDate(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }
}
