package com.wangxiaolu.promotion.domain.activityplanv2.mapper;

import com.alibaba.fastjson.JSONArray;
import com.wangxiaolu.promotion.domain.activityplanv2.mapper.entity.ActivityPlanInfoDo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.wangxiaolu.promotion.domain.manage.wrapperQo.ActivityPlanInfoWrapper;
import com.wangxiaolu.promotion.pojo.activity.planv2.dto.ActivityPlanInfoDto;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
* @author a02200059
* @description 针对表【activity_plan_info(活动计划列表)】的数据库操作Mapper
* @createDate 2025-01-21 14:41:08
* @Entity com.wangxiaolu.promotion.domain.activityplanv2.mapper.entity.ActivityPlanInfo
*/
@Mapper
@Repository
public interface ActivityPlanInfoMapper extends BaseMapper<ActivityPlanInfoDo> {

    void saveList(@Param("table") JSONArray table,@Param("recordId") Long recordId);

    ActivityPlanInfoDo selectPlan(String storeCode, Date date);

    void updateIsDelete(@Param("planIds") List<Long> planIds,@Param("employeeNo") String employeeNo);

    Integer selectNotDelCount(@Param("planIds") List<Long> planIds,@Param("employeeNo") String employeeNo);

    void updateOne(@Param("pDo") ActivityPlanInfoDo pDo,@Param("recordId") Long recordId);

    List<ActivityPlanInfoDo> selectTodayCount(List<Long> planIds);

    void updatePlanStatus(@Param("id") Long planId, @Param("status") Integer status);

    List<ActivityPlanInfoDo> findClockList(ActivityPlanInfoWrapper wrapper);

    void updateByIds(@Param("ids") List<Long> planIds, @Param("planDto") ActivityPlanInfoDto planDto);

    /**
     * 查询符合条件的门店编码和名称（去重）
     * @param date 日期阈值（格式：yyyy-MM-dd）
     * @param storeNameKeyword 门店名称关键词
     * @return 包含store_code和store_name的结果列表
     */
    @Select({
            "<script>",
            "SELECT DISTINCT api.store_code AS storeCode, api.store_name AS storeName ",
            "FROM activity_plan_info api ",
            "WHERE api.`date` > #{date} ",
            "<if test='storeNameKeyword != null and storeNameKeyword != \"\"'>",
            "AND api.store_name LIKE CONCAT('%', #{storeNameKeyword}, '%')",
            "</if>",
            "</script>"
    })
    List<Map<String, String>> selectStoreInfoByCondition(
            @Param("date") String date,
            @Param("storeNameKeyword") String storeNameKeyword
    );
}




