package com.wangxiaolu.promotion.controller.yun;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.utils.AliyunUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author : liqiulin
 * @date : 2025-02-06 13
 * @describe :
 */
@Slf4j
@RestController
@RequestMapping("/user/aliyun/")
public class AliyunGetToken {

    @Autowired
    private AliyunUtils aliyunUtils;

    @GetMapping("/signature")
    public R getSignature() {
        try {
            return R.success(aliyunUtils.getSignature());
        }catch (JsonProcessingException e){
            return R.fail();
        }
    }
}
