package com.wangxiaolu.promotion.controller.activityplanv2;

import com.wangxiaolu.promotion.exception.DataException;
import com.wangxiaolu.promotion.pojo.activity.manage.vo.ActivityPlanVo;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.activityplanv2.PromPlanCoreService;
import com.wangxiaolu.promotion.service.user.ManageEmployeeQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * @author : liqiulin
 * @date : 2025-01-07 13
 * @describe :
 */
@RestController
@RequestMapping("/plan/v2/core")
public class PromPlanCoreController {

    @Autowired
    private PromPlanCoreService promPlanCoreService;
    @Autowired
    private ManageEmployeeQueryService manageEmployeeQueryService;


    /**
     * 城市经理 - 上传计划
     * 当月只能上传次月的新增（当月需要新增需要交由职能角色上传）
     */
    @PostMapping("/self/upload")
    public R selfPlan(@RequestBody ActivityPlanVo activityPlanVo) {
        // 判断当前账号是否是城市经理
        boolean isSelf = manageEmployeeQueryService.isOneSelf(activityPlanVo.getEmployeeId());
        if (!isSelf) {
            throw new DataException(RCode.EMP_PRIVILEGE_ERROR);
        }

        try {
            String[] urlArr = activityPlanVo.getExcelUrl().split("weda-uploader/");
            String fileId = urlArr[urlArr.length - 1];
            if (fileId.length() > 53) {
                throw new DataException(RCode.ACTIVITY_PLAN_FILENAME_LONG);
            }

//todo            String filePath = "/home/" + fileId;
//            FileUtils.downloadExcel(activityPlanVo.getExcelUrl(), filePath);
            String filePath = "/Users/a02200059/Desktop/测试新增v3.xlsx";
            activityPlanVo.setExcelId(fileId);
            Map<String, Object> map = promPlanCoreService.selfPlanUp(activityPlanVo, filePath);
            return R.success(map);
        } catch (DataException e) {
            return new R(e.getCode(), e.getMsg(), null);
        }
    }

    @GetMapping("/self/upload/{uuid}")
    public R selfPlanAf(@PathVariable("uuid") String planUuid){
        promPlanCoreService.selfPlanAf(planUuid);
        return R.success();
    }

    /**
     * 职能角色 - 上传计划
     */
    @GetMapping("/auth/upload")
    public void authPlan() {


    }



}
