package com.wangxiaolu.promotion.pojo.activity.temporary.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author : liqiulin
 * @date : 2024-04-23 13
 * @describe : 促销员打卡数据模型
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Accessors(chain = true)
public class TemporaryClockVo {
    /**
     * 打卡记录id
     */
    Long id;

    /**
     * 打卡类型：1、上班卡；2、午休下班卡；3、午休上班卡；4、下班卡
     */
    @NotNull(message = "无打卡类型")
    @Range(max = 4, min = 1, message = "超出状态")
    Integer clockType;

    /**
     * temporaryId
     */
    @NotNull(message = "找不到打卡人")
    Integer temporaryId;

    String temporaryName;

    // 店铺勤策id
    String storeQcId;

    // 店铺名称
    String storeName;

    // 上班打卡地点
    @NotBlank(message = "请选择打卡地址")
    String clockAddress;

    // 上班打卡经纬度
    @NotBlank(message = "请选择打卡地点")
    String clockCoordinates;

    // 上班打卡图片
    @NotBlank(message = "请上传图片")
    String clockPhoto;
    @NotBlank(message = "未找到图片")
    String clockPhotoFieldId;

}
