package com.wangxiaolu.promotion.pojo.activity.temporary.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-04-17 19
 * @describe : 促销员今日活动上报VO
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class TemporaryActivityDataVo {
    /**
     * 促销员活动上报id
     * 关联ID：temporary_activity_reported表id
     */
    Long activityReportedId;
    /**
     * 促销员id
     * temporaryInfo表id
     */
    @NotNull(message = "促销员账号异常")
    private Integer temporaryId;

    /**
     * 促销员姓名
     * temporaryInfo表name
     */
    private String temporaryName;


    /**
     * 活动店铺Id
     */
    @NotNull(message = "活动店铺异常")
    private String storeQcId;

    /**
     * 推广试吃照片
     * 只传增量，存量数据前端不再返回，增量数据直接保存到DB中
     */
    List<String> tgscPhotoUrls;

    /**
     * 推广互动照片
     * 只传增量，存量数据前端不再返回，增量数据直接保存到DB中
     */
    List<String> tghdPhotoUrls;

    /**
     * 推广成交照片
     * 只传增量，存量数据前端不再返回，增量数据直接保存到DB中
     */
    List<String> tgcjPhotoUrls;

}
