package com.wangxiaolu.promotion.domain.activity.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityPhotoDao;
import com.wangxiaolu.promotion.domain.activity.mapper.TemporaryActivityPhotoMapper;
import com.wangxiaolu.promotion.domain.activity.mapper.entity.TemporaryActivityPhotoDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author : liqiulin
 * @date : 2024-05-09 11
 * @describe :
 */
@Service
public class TemporaryActivityPhotoDaoImpl implements TemporaryActivityPhotoDao {

    @Autowired
    TemporaryActivityPhotoMapper temporaryActivityPhotoMapper;

    @Override
    public void saveReportedList(Integer temporaryId, Long reportedId, Integer photoType, List<String> urls) {
        for (String photoUrl : urls) {
            String[] photoArr = photoUrl.split("/");
            TemporaryActivityPhotoDO photoDo = new TemporaryActivityPhotoDO();
            photoDo.setTemporaryId(temporaryId).setReportedId(reportedId).setType(photoType).setPhotoUrl(photoUrl).setPhotoFiledId(photoArr[photoArr.length - 1]);
            temporaryActivityPhotoMapper.insert(photoDo);
        }
    }

    /**
     * 活动上报图片查询
     *
     * @param temporaryId 促销员id
     * @param reportedId  活动id
     */
    @Override
    public Map<Integer, List<String>> findReportedGroup(Integer temporaryId, Long reportedId) {
        LambdaQueryWrapper<TemporaryActivityPhotoDO> wq = new LambdaQueryWrapper<>();
        wq.eq(TemporaryActivityPhotoDO::getReportedId, reportedId).eq(TemporaryActivityPhotoDO::getIsDelete, 1);
        List<TemporaryActivityPhotoDO> dos = temporaryActivityPhotoMapper.selectList(wq);
        if (CollectionUtils.isEmpty(dos)) {
            return null;
        }
        Map<Integer, List<String>> groupPhoto = dos.stream().collect(Collectors.groupingBy(TemporaryActivityPhotoDO::getType, Collectors.mapping(TemporaryActivityPhotoDO::getPhotoUrl, Collectors.toList())));
        return groupPhoto;
    }
}
