package com.wangxiaolu.promotion.pojo.user.vo;

import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.result.basedata.RCode;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotBlank;

/**
 * @author : liqiulin
 * @date : 2024-03-28 18
 * @describe : 接收用
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class UserLoginParam {

    String loginName;
    String password;

    public void validate(){
        if (StringUtils.isBlank(loginName) || StringUtils.isBlank(password)){
            throw new ParamException(RCode.LOGIN_PARAM_ERROR,null);
        }
    }
}
