package com.wangxiaolu.promotion.domain.user.mapper.entity;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 勤策-客户管理-终端
 * @TableName qc_clientele_shop
 */
@TableName(value ="qince_clientele_store")
@Data
public class QinCeClienteleStoreDO implements Serializable {
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 勤策的门店唯一ID
     */
    @JsonProperty("id")
    private String qcId;

    /**
     * 创建人id，来源勤策员工唯一ID
     */
    @JsonProperty("creator_waiqin_id")
    private String creatorWaiqinId;

    /**
     * 创建人名称
     */
    @JsonProperty("creator_name")
    private String creatorName;

    /**
     * 门店名称
     */
    @JsonProperty("store_name")
    private String storeName;

    /**
     * 门店编码
     */
    @JsonProperty("store_code")
    private String storeCode;

    /**
     * 门店经理,多门店经理名称间以“,”分隔
     */
    @JsonProperty("store_manager")
    private String storeManager;
    /**
     * 门店类型名称
     */
    @JsonProperty("store_type")
    private String storeType;

    /**
     * 门店类型编码
     */
    @JsonProperty("store_type_code")
    private String storeTypeCode;

    /**
     * 勤策门店所属部门ID
     */
    @JsonProperty("store_dept_waiqin365_id")
    private String storeDeptWaiqin365Id;

    /**
     * 门店部门名称
     */
    @JsonProperty("store_dept_name")
    private String storeDeptName;

    /**
     * 门店所属行政区域-省份名称，如：北京市、江苏省
     */
    @JsonProperty("store_mss_province")
    private String storeMssProvince;

    /**
     * 门店所属行政区域-城市名称，如：南京市
     */
    @JsonProperty("store_mss_city")
    private String storeMssCity;

    /**
     * 门店所属行政区域-区县名称，如：鼓楼区
     */
    @JsonProperty("store_mss_area")
    private String storeMssArea;

    /**
     * 门店所属行政区域-乡镇街道名称，如：宁海路街道
     */
    @JsonProperty("store_mss_street")
    private String storeMssStreet;

    /**
     * 门店所在地址
     */
    @JsonProperty("store_addr")
    private String storeAddr;

    /**
     * 合作状态编码。0：终止合作，1：合作中，2：未合作，3：有意向
     */
    @JsonProperty("store_cooperate_status")
    private String storeCooperateStatus;

    /**
     * 门店分层标签名称。多分层标签名称以“,”分隔
     */
    @JsonProperty("store_label")
    private String storeLabel;

    /**
     * 门店分层标签id。多分层标签id以“,”分隔
     */
    @JsonProperty("store_label_id")
    private String storeLabelId;

    /**
     * 是否直接交易客户。0：是，1：否
     */
    @JsonProperty("store_sale_direct")
    private String storeSaleDirect;

    /**
     * 门店修改时间。格式：yyyy-MM-dd HH:mm:ss
     */
    @JsonProperty("store_modify_time")
    private String storeModifyTime;

    /**
     * 门店修改人名称
     */
    @JsonProperty("store_modifyier_name")
    private String storeModifyierName;

    /**
     * 创建方式
     */
    @JsonProperty("store_source_type")
    private String storeSourceType;

    /**
     * 门店门头照信息，多个以“,”号隔开
     */
    @JsonProperty("store_pictures")
    private String storePictures;

    /**
     * 门店客户经理编码，即为员工登录账号，多客户经理唯一标识间以英文“,”隔开
     */
    @JsonProperty("store_manager_code")
    private String storeManagerCode;

    /**
     * 创建人编码
     */
    @JsonProperty("store_creator_code")
    private String storeCreatorCode;

    /**
     * 修改人编码，取最新修改记录操作人
     */
    @JsonProperty("store_modifier_code")
    private String storeModifierCode;

    /**
     * 门店审批状态。1：待审批，2：审批打回，3：审批通过
     */
    @JsonProperty("store_approval_status")
    private String storeApprovalStatus;

    /**
     * 系统名称
     */
    private String lineName;
    /**
     * 是否双T门店
     */
    private String bothT;

    /**
     * 经销商名称
     */
    private String dealersName;
    private String dealerId;

    @TableField(exist = false)
    @JsonProperty("dealers")
    private List<JSONObject> dealers;

    /**
     *  "store_ext_key": "系统名称",
     *  "store_ext_value": "永辉超市"
     */
    @TableField(exist = false)
    @JsonProperty("exts")
    private List<Exts> exts;

    /**
     * 门店删除状态。0：删除，1：正常
     */
    @JsonProperty("store_status")
    private String storeStatus;

    /**
     * 创建日期。格式：yyyy-MM-dd HH:mm:ss
     */
    @JsonProperty("create_time")
    private String createTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

    @Data
    public class Exts{
        @JsonProperty("store_ext_key")
        private String storeExtKey;
        @JsonProperty("store_ext_value")
        private String storeExtValue;
    }

    public void setExt() {
        for (Exts e : exts) {
            if ("系统名称".equals(e.getStoreExtKey())) {
                this.lineName = e.getStoreExtValue();
            }
            if ("是否双T门店".equals(e.getStoreExtKey())) {
                this.bothT = e.getStoreExtValue();
            }
        }
    }
}