package com.wangxiaolu.promotion.service.user.impl;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.wangxiaolu.promotion.service.user.TencentLocationQueryService;
import com.wangxiaolu.promotion.utils.TencentMapUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @Author: DouXinYu
 * @Date: 2026-01-12 11:16
 * @Description: 腾讯位置查询服务实现类
 */
@Service
public class TencentLocationQueryServiceImpl implements TencentLocationQueryService {

    private static final String TRIPLE_REGION_CACHE_KEY = "promotion:district:triple_level";
    private static final long CACHE_EXPIRE = 86400L;
    private static final Type REGION_NODE_TYPE = new TypeToken<List<TencentMapUtil.RegionNode>>() {}.getType();
    private static final Gson GSON = new Gson();

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Autowired
    TencentMapUtil tencentMapUtil;

    @Override
    public TencentMapUtil.AddressInfo getAddressByLngLat(double lng, double lat) {
        return tencentMapUtil.getAddressByLngLat(lng, lat);
    }

    @Override
    public List<TencentMapUtil.RegionNode> getAddressList() {
        String cacheJson = stringRedisTemplate.opsForValue().get(TRIPLE_REGION_CACHE_KEY);
        if (cacheJson != null && !cacheJson.isEmpty()) {
            return GSON.fromJson(cacheJson, REGION_NODE_TYPE);
        }

        List<TencentMapUtil.RegionNode> regionList = tencentMapUtil.getTripleLevelRegion();
        if (!regionList.isEmpty()) {
            stringRedisTemplate.opsForValue().set(TRIPLE_REGION_CACHE_KEY, GSON.toJson(regionList), CACHE_EXPIRE, TimeUnit.SECONDS);
        }
        return regionList;
    }
}
