package com.wangxiaolu.promotion.service.activity.temporary.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.common.redis.RedisKeys;
import com.wangxiaolu.promotion.common.redis.service.RedisCache;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityMarketCellDao;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityPhotoDao;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityReportedDao;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryActivityWrapper;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryClockWrapper;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryMarketCellWrapper;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryPhotoWrapper;
import com.wangxiaolu.promotion.enums.activity.ActivityPhotoType;
import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityMarketCellDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityPhotoDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityReportedDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryClockDto;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityClockQueryService;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-18 13
 * @describe :
 */
@Service
@Slf4j
public class TemporaryActivityQueryServiceImpl implements TemporaryActivityQueryService {

    @Autowired
    RedisCache redisCache;
    @Autowired
    TemporaryActivityReportedDao temporaryActivityReportedDao;
    @Autowired
    TemporaryActivityPhotoDao temporaryActivityPhotoDao;
    @Autowired
    TemporaryActivityMarketCellDao temporaryActivityMarketCellDao;
    @Autowired
    TemporaryActivityClockQueryService temporaryActivityClockQueryService;
    /**
     * 根据促销员id查询所有任务
     */
    @Override
    public void findtemporaryIdActivityDataList(Long temporaryId, PageInfo pageInfo) {
        TemporaryActivityWrapper taw = JSONObject.parseObject(JSONObject.toJSONString(pageInfo.getQueryParams()), TemporaryActivityWrapper.class);
        taw = Objects.isNull(taw) ? new TemporaryActivityWrapper() : taw;
        taw.setTemporaryId(temporaryId);
        temporaryActivityReportedDao.findPage(taw, pageInfo);
    }


    /**
     * 根据促销员id查询今日任务
     */
    @Override
    public TemporaryActivityReportedDto findtemporaryIdTodayActivityData(Long temporaryId) {
        TemporaryActivityReportedDto dto = temporaryActivityReportedDao.findOneByCurrentDate(temporaryId);
        findActivityReportedPhoto(dto);
        return dto;
    }

    @Override
    public TemporaryActivityReportedDto findTemporaryActivityById(Long activityId) {
        TemporaryActivityReportedDto dto = temporaryActivityReportedDao.findOneById(activityId);
        findActivityReportedPhotoInfo(dto);

        // 验证随机任务照片数量  上周提到每天下午5:30～7:30的随机拍照一次的任务（客流量大的时候要保证促销员在售卖位置）
        TemporaryClockWrapper wer = new TemporaryClockWrapper();
        wer.setTemporaryId(dto.getTemporaryId())
                .setReportedId(activityId);
        TemporaryClockDto clockInfo = temporaryActivityClockQueryService.findClockInfo(wer);
        // 设置 高峰期在岗
        TemporaryPhotoWrapper wrapper = new TemporaryPhotoWrapper();
        wrapper.setTemporaryId(dto.getTemporaryId())
                .setClockId(clockInfo.getId())
                .setType(ActivityPhotoType.RANDOM_TASK.getType() );
        List<TemporaryActivityPhotoDto> temporaryActivityPhotoDtos = temporaryActivityPhotoDao.selectPhotos(wrapper);
        dto.setRandTaskClockPhotoUrls(temporaryActivityPhotoDtos);

        return dto;
    }

    @Override
    public JSONArray findActivityMarketCell( Long temporaryId) {
        /**
         * 将数据保存到redis中Generators
         */
        String key = RedisKeys.TemporaryKeys.TEMPORARY_ACTIVITY_MARKET_CELL.getKey() + temporaryId + "_" + DateUtil.today();
        return redisCache.getToJsonArray(key);
    }

    @Override
    public List<TemporaryActivityMarketCellDto> findActivityMarketCellByDb(Long activityId) {
        List<TemporaryActivityMarketCellDto> dtos = temporaryActivityMarketCellDao.selectList(new TemporaryMarketCellWrapper().setActivityId(activityId));
        return dtos;
    }

    @Override
    public List<TemporaryActivityReportedDto> findListByPlan(Long planId) {
        TemporaryActivityWrapper taw = new TemporaryActivityWrapper().setPlanId(planId);
        List<TemporaryActivityReportedDto> reportedDtos = temporaryActivityReportedDao.findList(taw);
        for (TemporaryActivityReportedDto reportedDto : reportedDtos) {
            findActivityReportedPhotoInfo(reportedDto);
        }
        return reportedDtos;
    }

    private void findActivityReportedPhoto(TemporaryActivityReportedDto dto) {
        if (Objects.isNull(dto)) {
            return;
        }
        Map<Integer, List<String>> reportedGroup = temporaryActivityPhotoDao.findReportedGroup(dto.getTemporaryId(), dto.getId());
        if (!CollectionUtils.isEmpty(reportedGroup)) {
            dto.setTgscPhotoUrls(reportedGroup.get(ActivityPhotoType.TGSC.getType()));
            dto.setTghdPhotoUrls(reportedGroup.get(ActivityPhotoType.TGHD.getType()));
            dto.setTgcjPhotoUrls(reportedGroup.get(ActivityPhotoType.TGCJ.getType()));
            dto.setScpPhotoUrls(reportedGroup.get(ActivityPhotoType.TASTY_PHOTO.getType()));
            dto.setPsvPhotoUrls(reportedGroup.get(ActivityPhotoType.POS_SELL_VOUCHER.getType()));
            dto.setPfzpPhotoUrls(reportedGroup.get(ActivityPhotoType.SEND_GIFT_PHOTO.getType()));
            dto.setGfqPhotoUrls(reportedGroup.get(ActivityPhotoType.RANDOM_TASK.getType()));
            dto.setScbbwlPhotoUrls(reportedGroup.get(ActivityPhotoType.TASTY_MATERIALS.getType()));
        }
    }

    private void findActivityReportedPhotoInfo(TemporaryActivityReportedDto dto) {
        if (Objects.isNull(dto)) {
            return;
        }
        Map<Integer, List<TemporaryActivityPhotoDto>> reportedGroup = temporaryActivityPhotoDao.findReportedInfoGroup(dto.getTemporaryId(), dto.getId());
        if (!CollectionUtils.isEmpty(reportedGroup)) {
            dto.setTgscPhotoInfos(reportedGroup.get(ActivityPhotoType.TGSC.getType()));
            dto.setTghdPhotoInfos(reportedGroup.get(ActivityPhotoType.TGHD.getType()));
            dto.setTgcjPhotoInfos(reportedGroup.get(ActivityPhotoType.TGCJ.getType()));
            dto.setScpPhotoInfos(reportedGroup.get(ActivityPhotoType.TASTY_PHOTO.getType()));
            dto.setPsvPhotoInfos(reportedGroup.get(ActivityPhotoType.POS_SELL_VOUCHER.getType()));
            dto.setPfzpPhotoInfos(reportedGroup.get(ActivityPhotoType.SEND_GIFT_PHOTO.getType()));
            dto.setGfqPhotoInfos(reportedGroup.get(ActivityPhotoType.RANDOM_TASK.getType()));
            dto.setScbbwlPhotoInfos(reportedGroup.get(ActivityPhotoType.TASTY_MATERIALS.getType()));
        }
    }
}
