package com.wangxiaolu.promotion.domain.inspection.mapper.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 稽查信息表
 * @TableName inspection_info
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("inspection_info")
public class InspectionInfoDO implements Serializable {
    /**
     * 当前稽核ID
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 当前门店对应的计划
     */
    private Long planId;

    /**
     * 所属战区名称
     */
    private String depQcOrgName;

    /**
     * 经销商代码
     */
    private String dealerId;

    /**
     * 经销商名称
     */
    private String dealerName;

    /**
     * 门店编码
     */
    private String storeCode;

    /**
     * 门店名称
     */
    private String storeName;

    /**
     * 门店地址
     */
    private String addr;

    /**
     * 当前稽查的活动形式
     */
    private String pattern;

    /**
     * 稽查店铺的日期
     */
    private Date inspectionDate;

    /**
     * 开始稽查的具体时间
     */
    private String inspectionTime;

    /**
     * 结束稽查离开店铺的时间
     */
    private String leaveStoreTime;

    /**
     * 促销员是否在岗的状态（是/否）
     */
    private String onDutyStatus;

    /**
     * 促销员的在岗率（百分比）
     */
    private BigDecimal onDutyRate;

    /**
     * 实际在岗的促销人员数量
     */
    private Integer onDutyCount;

    /**
     * 促销员当前是否在岗（是/否）
     */
    private String isOnDuty;

    /**
     * 促销员未在岗时电话拨出的时间
     */
    private String offDutyCallTime;

    /**
     * 电话是否接通（是/否）
     */
    private String isCallConnected;

    /**
     * 5分钟后再次拨打电话是否接通（是/否）
     */
    private String isReconnectedAfter5min;

    /**
     * 10分钟内是否返回岗位（是/否）
     */
    private String isBackToWorkWithin10min;

    /**
     * 本次稽查的总得分
     */
    private Integer totalScore;

    /**
     * 销售相关考核得分（满分50分）
     */
    private Integer salesAssessmentScore;

    /**
     * 促销相关考核得分（满分50分）
     */
    private Integer promotionAssessmentScore;

    /**
     * 是否有档期或特价活动得分（满分20分）
     */
    private Integer hasSchedulePromotionScore;

    /**
     * 地堆上是否陈列主推产品得分（满分8分）
     */
    private Integer groundStackHasMainProductScore;

    /**
     * 地堆上是否只陈列王小卤产品得分（满分8分）
     */
    private Integer groundStackOnlyWangxiaoluScore;

    /**
     * 地堆铺货是否饱满得分（满分4分）
     */
    private Integer groundStackStockFullScore;

    /**
     * 是否配备各类宣传物料得分（满分10分）
     */
    private Integer hasPromotionMaterialsScore;

    /**
     * 是否穿着王小卤品牌围裙得分（满分3分）
     */
    private Integer wearsWangxiaoluApronScore;

    /**
     * 是否准备试吃品得分（满分5分）
     */
    private Integer hasTastingProductScore;

    /**
     * 是否设置试吃台得分（满分3分）
     */
    private Integer hasTastingTableScore;

    /**
     * 是否准备试吃盘得分（满分3分）
     */
    private Integer hasTastingPlateScore;

    /**
     * 是否准备试吃杯得分（满分3分）
     */
    private Integer hasTastingCupScore;

    /**
     * 是否佩戴口罩和手套得分（满分3分）
     */
    private Integer wearsMaskGlovesScore;

    /**
     * 是否提供牙签加分（满分2分）
     */
    private Integer hasToothpickBonusScore;

    /**
     * 是否配备垃圾桶加分（满分2分）
     */
    private Integer hasGarbageCanBonusScore;

    /**
     * 是否知晓远距离招揽话术得分（满分5分）
     */
    private Integer knowsDistanceSolicitSkillScore;

    /**
     * 是否知晓黑鸭或卤香产品卖点得分（满分5分）
     */
    private Integer knowsProductSellingPointsScore;

    /**
     * 人流经过时是否主动迎接得分（满分5分）
     */
    private Integer greetsCustomersActivelyScore;

    /**
     * 是否讲解产品卖点推荐产品得分（满分3分）
     */
    private Integer introducesProductScoresScore;

    /**
     * 是否有促进销售的动作得分（满分2分）
     */
    private Integer promotesSalesActivelyScore;

    /**
     * 是否配置活动赠品得分（满分5分）
     */
    private Integer hasPromotionGiftsScore;

    /**
     * 是否主动销售非王小卤产品得分（满分5分）
     */
    private Integer sellsNonWangxiaoluProductsScore;

    /**
     * 促销活动的具体内容描述
     */
    private String promotionActivityContent;

    /**
     * 是否设置了地堆陈列（是/否）
     */
    private String hasGroundStack;

    /**
     * 是否有黑鸭产品陈列（是/否）
     */
    private String hasBlackDuckDisplay;

    /**
     * 是否有黑鸭产品试吃品（是/否）
     */
    private String hasBlackDuckTasting;

    /**
     * 其他品牌是否设置了试吃台（是/否）
     */
    private String otherBrandHasTastingTable;

    /**
     * 10分钟内经过促销人员的人流数量
     */
    private BigDecimal pedestrianCountWithin10min;

    /**
     * 试吃品的总数量
     */
    private BigDecimal totalTastingProductCount;

    /**
     * 按口味统计的试吃品数量
     */
    private String tastingProductCountByFlavor;

    /**
     * 其他品牌试吃台的佐证照片链接
     */
    private String otherBrandTastingTableProofUrl;

    /**
     * 销售非王小卤产品的佐证照片链接
     */
    private String nonWangxiaoluSalesProofUrl;

    /**
     * 门头照
     */
    private String storePicture;

    /**
     * 促销员在岗/离岗佐证照
     */
    private String temWorkPhotos;

    /**
     * 特殊陈列照片
     */
    private String storeTcPhoto;

    /**
     * 主货架照片
     */
    private String storeZhiPhoto;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        InspectionInfoDO other = (InspectionInfoDO) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getPlanId() == null ? other.getPlanId() == null : this.getPlanId().equals(other.getPlanId()))
            && (this.getDepQcOrgName() == null ? other.getDepQcOrgName() == null : this.getDepQcOrgName().equals(other.getDepQcOrgName()))
            && (this.getDealerId() == null ? other.getDealerId() == null : this.getDealerId().equals(other.getDealerId()))
            && (this.getDealerName() == null ? other.getDealerName() == null : this.getDealerName().equals(other.getDealerName()))
            && (this.getStoreCode() == null ? other.getStoreCode() == null : this.getStoreCode().equals(other.getStoreCode()))
            && (this.getStoreName() == null ? other.getStoreName() == null : this.getStoreName().equals(other.getStoreName()))
            && (this.getAddr() == null ? other.getAddr() == null : this.getAddr().equals(other.getAddr()))
            && (this.getPattern() == null ? other.getPattern() == null : this.getPattern().equals(other.getPattern()))
            && (this.getInspectionDate() == null ? other.getInspectionDate() == null : this.getInspectionDate().equals(other.getInspectionDate()))
            && (this.getInspectionTime() == null ? other.getInspectionTime() == null : this.getInspectionTime().equals(other.getInspectionTime()))
            && (this.getLeaveStoreTime() == null ? other.getLeaveStoreTime() == null : this.getLeaveStoreTime().equals(other.getLeaveStoreTime()))
            && (this.getOnDutyStatus() == null ? other.getOnDutyStatus() == null : this.getOnDutyStatus().equals(other.getOnDutyStatus()))
            && (this.getOnDutyRate() == null ? other.getOnDutyRate() == null : this.getOnDutyRate().equals(other.getOnDutyRate()))
            && (this.getOnDutyCount() == null ? other.getOnDutyCount() == null : this.getOnDutyCount().equals(other.getOnDutyCount()))
            && (this.getIsOnDuty() == null ? other.getIsOnDuty() == null : this.getIsOnDuty().equals(other.getIsOnDuty()))
            && (this.getOffDutyCallTime() == null ? other.getOffDutyCallTime() == null : this.getOffDutyCallTime().equals(other.getOffDutyCallTime()))
            && (this.getIsCallConnected() == null ? other.getIsCallConnected() == null : this.getIsCallConnected().equals(other.getIsCallConnected()))
            && (this.getIsReconnectedAfter5min() == null ? other.getIsReconnectedAfter5min() == null : this.getIsReconnectedAfter5min().equals(other.getIsReconnectedAfter5min()))
            && (this.getIsBackToWorkWithin10min() == null ? other.getIsBackToWorkWithin10min() == null : this.getIsBackToWorkWithin10min().equals(other.getIsBackToWorkWithin10min()))
            && (this.getTotalScore() == null ? other.getTotalScore() == null : this.getTotalScore().equals(other.getTotalScore()))
            && (this.getSalesAssessmentScore() == null ? other.getSalesAssessmentScore() == null : this.getSalesAssessmentScore().equals(other.getSalesAssessmentScore()))
            && (this.getPromotionAssessmentScore() == null ? other.getPromotionAssessmentScore() == null : this.getPromotionAssessmentScore().equals(other.getPromotionAssessmentScore()))
            && (this.getHasSchedulePromotionScore() == null ? other.getHasSchedulePromotionScore() == null : this.getHasSchedulePromotionScore().equals(other.getHasSchedulePromotionScore()))
            && (this.getGroundStackHasMainProductScore() == null ? other.getGroundStackHasMainProductScore() == null : this.getGroundStackHasMainProductScore().equals(other.getGroundStackHasMainProductScore()))
            && (this.getGroundStackOnlyWangxiaoluScore() == null ? other.getGroundStackOnlyWangxiaoluScore() == null : this.getGroundStackOnlyWangxiaoluScore().equals(other.getGroundStackOnlyWangxiaoluScore()))
            && (this.getGroundStackStockFullScore() == null ? other.getGroundStackStockFullScore() == null : this.getGroundStackStockFullScore().equals(other.getGroundStackStockFullScore()))
            && (this.getHasPromotionMaterialsScore() == null ? other.getHasPromotionMaterialsScore() == null : this.getHasPromotionMaterialsScore().equals(other.getHasPromotionMaterialsScore()))
            && (this.getWearsWangxiaoluApronScore() == null ? other.getWearsWangxiaoluApronScore() == null : this.getWearsWangxiaoluApronScore().equals(other.getWearsWangxiaoluApronScore()))
            && (this.getHasTastingProductScore() == null ? other.getHasTastingProductScore() == null : this.getHasTastingProductScore().equals(other.getHasTastingProductScore()))
            && (this.getHasTastingTableScore() == null ? other.getHasTastingTableScore() == null : this.getHasTastingTableScore().equals(other.getHasTastingTableScore()))
            && (this.getHasTastingPlateScore() == null ? other.getHasTastingPlateScore() == null : this.getHasTastingPlateScore().equals(other.getHasTastingPlateScore()))
            && (this.getHasTastingCupScore() == null ? other.getHasTastingCupScore() == null : this.getHasTastingCupScore().equals(other.getHasTastingCupScore()))
            && (this.getWearsMaskGlovesScore() == null ? other.getWearsMaskGlovesScore() == null : this.getWearsMaskGlovesScore().equals(other.getWearsMaskGlovesScore()))
            && (this.getHasToothpickBonusScore() == null ? other.getHasToothpickBonusScore() == null : this.getHasToothpickBonusScore().equals(other.getHasToothpickBonusScore()))
            && (this.getHasGarbageCanBonusScore() == null ? other.getHasGarbageCanBonusScore() == null : this.getHasGarbageCanBonusScore().equals(other.getHasGarbageCanBonusScore()))
            && (this.getKnowsDistanceSolicitSkillScore() == null ? other.getKnowsDistanceSolicitSkillScore() == null : this.getKnowsDistanceSolicitSkillScore().equals(other.getKnowsDistanceSolicitSkillScore()))
            && (this.getKnowsProductSellingPointsScore() == null ? other.getKnowsProductSellingPointsScore() == null : this.getKnowsProductSellingPointsScore().equals(other.getKnowsProductSellingPointsScore()))
            && (this.getGreetsCustomersActivelyScore() == null ? other.getGreetsCustomersActivelyScore() == null : this.getGreetsCustomersActivelyScore().equals(other.getGreetsCustomersActivelyScore()))
            && (this.getIntroducesProductScoresScore() == null ? other.getIntroducesProductScoresScore() == null : this.getIntroducesProductScoresScore().equals(other.getIntroducesProductScoresScore()))
            && (this.getPromotesSalesActivelyScore() == null ? other.getPromotesSalesActivelyScore() == null : this.getPromotesSalesActivelyScore().equals(other.getPromotesSalesActivelyScore()))
            && (this.getHasPromotionGiftsScore() == null ? other.getHasPromotionGiftsScore() == null : this.getHasPromotionGiftsScore().equals(other.getHasPromotionGiftsScore()))
            && (this.getSellsNonWangxiaoluProductsScore() == null ? other.getSellsNonWangxiaoluProductsScore() == null : this.getSellsNonWangxiaoluProductsScore().equals(other.getSellsNonWangxiaoluProductsScore()))
            && (this.getPromotionActivityContent() == null ? other.getPromotionActivityContent() == null : this.getPromotionActivityContent().equals(other.getPromotionActivityContent()))
            && (this.getHasGroundStack() == null ? other.getHasGroundStack() == null : this.getHasGroundStack().equals(other.getHasGroundStack()))
            && (this.getHasBlackDuckDisplay() == null ? other.getHasBlackDuckDisplay() == null : this.getHasBlackDuckDisplay().equals(other.getHasBlackDuckDisplay()))
            && (this.getHasBlackDuckTasting() == null ? other.getHasBlackDuckTasting() == null : this.getHasBlackDuckTasting().equals(other.getHasBlackDuckTasting()))
            && (this.getOtherBrandHasTastingTable() == null ? other.getOtherBrandHasTastingTable() == null : this.getOtherBrandHasTastingTable().equals(other.getOtherBrandHasTastingTable()))
            && (this.getPedestrianCountWithin10min() == null ? other.getPedestrianCountWithin10min() == null : this.getPedestrianCountWithin10min().equals(other.getPedestrianCountWithin10min()))
            && (this.getTotalTastingProductCount() == null ? other.getTotalTastingProductCount() == null : this.getTotalTastingProductCount().equals(other.getTotalTastingProductCount()))
            && (this.getTastingProductCountByFlavor() == null ? other.getTastingProductCountByFlavor() == null : this.getTastingProductCountByFlavor().equals(other.getTastingProductCountByFlavor()))
            && (this.getOtherBrandTastingTableProofUrl() == null ? other.getOtherBrandTastingTableProofUrl() == null : this.getOtherBrandTastingTableProofUrl().equals(other.getOtherBrandTastingTableProofUrl()))
            && (this.getNonWangxiaoluSalesProofUrl() == null ? other.getNonWangxiaoluSalesProofUrl() == null : this.getNonWangxiaoluSalesProofUrl().equals(other.getNonWangxiaoluSalesProofUrl()))
            && (this.getStorePicture() == null ? other.getStorePicture() == null : this.getStorePicture().equals(other.getStorePicture()))
            && (this.getTemWorkPhotos() == null ? other.getTemWorkPhotos() == null : this.getTemWorkPhotos().equals(other.getTemWorkPhotos()))
            && (this.getStoreTcPhoto() == null ? other.getStoreTcPhoto() == null : this.getStoreTcPhoto().equals(other.getStoreTcPhoto()))
            && (this.getStoreZhiPhoto() == null ? other.getStoreZhiPhoto() == null : this.getStoreZhiPhoto().equals(other.getStoreZhiPhoto()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getPlanId() == null) ? 0 : getPlanId().hashCode());
        result = prime * result + ((getDepQcOrgName() == null) ? 0 : getDepQcOrgName().hashCode());
        result = prime * result + ((getDealerId() == null) ? 0 : getDealerId().hashCode());
        result = prime * result + ((getDealerName() == null) ? 0 : getDealerName().hashCode());
        result = prime * result + ((getStoreCode() == null) ? 0 : getStoreCode().hashCode());
        result = prime * result + ((getStoreName() == null) ? 0 : getStoreName().hashCode());
        result = prime * result + ((getAddr() == null) ? 0 : getAddr().hashCode());
        result = prime * result + ((getPattern() == null) ? 0 : getPattern().hashCode());
        result = prime * result + ((getInspectionDate() == null) ? 0 : getInspectionDate().hashCode());
        result = prime * result + ((getInspectionTime() == null) ? 0 : getInspectionTime().hashCode());
        result = prime * result + ((getLeaveStoreTime() == null) ? 0 : getLeaveStoreTime().hashCode());
        result = prime * result + ((getOnDutyStatus() == null) ? 0 : getOnDutyStatus().hashCode());
        result = prime * result + ((getOnDutyRate() == null) ? 0 : getOnDutyRate().hashCode());
        result = prime * result + ((getOnDutyCount() == null) ? 0 : getOnDutyCount().hashCode());
        result = prime * result + ((getIsOnDuty() == null) ? 0 : getIsOnDuty().hashCode());
        result = prime * result + ((getOffDutyCallTime() == null) ? 0 : getOffDutyCallTime().hashCode());
        result = prime * result + ((getIsCallConnected() == null) ? 0 : getIsCallConnected().hashCode());
        result = prime * result + ((getIsReconnectedAfter5min() == null) ? 0 : getIsReconnectedAfter5min().hashCode());
        result = prime * result + ((getIsBackToWorkWithin10min() == null) ? 0 : getIsBackToWorkWithin10min().hashCode());
        result = prime * result + ((getTotalScore() == null) ? 0 : getTotalScore().hashCode());
        result = prime * result + ((getSalesAssessmentScore() == null) ? 0 : getSalesAssessmentScore().hashCode());
        result = prime * result + ((getPromotionAssessmentScore() == null) ? 0 : getPromotionAssessmentScore().hashCode());
        result = prime * result + ((getHasSchedulePromotionScore() == null) ? 0 : getHasSchedulePromotionScore().hashCode());
        result = prime * result + ((getGroundStackHasMainProductScore() == null) ? 0 : getGroundStackHasMainProductScore().hashCode());
        result = prime * result + ((getGroundStackOnlyWangxiaoluScore() == null) ? 0 : getGroundStackOnlyWangxiaoluScore().hashCode());
        result = prime * result + ((getGroundStackStockFullScore() == null) ? 0 : getGroundStackStockFullScore().hashCode());
        result = prime * result + ((getHasPromotionMaterialsScore() == null) ? 0 : getHasPromotionMaterialsScore().hashCode());
        result = prime * result + ((getWearsWangxiaoluApronScore() == null) ? 0 : getWearsWangxiaoluApronScore().hashCode());
        result = prime * result + ((getHasTastingProductScore() == null) ? 0 : getHasTastingProductScore().hashCode());
        result = prime * result + ((getHasTastingTableScore() == null) ? 0 : getHasTastingTableScore().hashCode());
        result = prime * result + ((getHasTastingPlateScore() == null) ? 0 : getHasTastingPlateScore().hashCode());
        result = prime * result + ((getHasTastingCupScore() == null) ? 0 : getHasTastingCupScore().hashCode());
        result = prime * result + ((getWearsMaskGlovesScore() == null) ? 0 : getWearsMaskGlovesScore().hashCode());
        result = prime * result + ((getHasToothpickBonusScore() == null) ? 0 : getHasToothpickBonusScore().hashCode());
        result = prime * result + ((getHasGarbageCanBonusScore() == null) ? 0 : getHasGarbageCanBonusScore().hashCode());
        result = prime * result + ((getKnowsDistanceSolicitSkillScore() == null) ? 0 : getKnowsDistanceSolicitSkillScore().hashCode());
        result = prime * result + ((getKnowsProductSellingPointsScore() == null) ? 0 : getKnowsProductSellingPointsScore().hashCode());
        result = prime * result + ((getGreetsCustomersActivelyScore() == null) ? 0 : getGreetsCustomersActivelyScore().hashCode());
        result = prime * result + ((getIntroducesProductScoresScore() == null) ? 0 : getIntroducesProductScoresScore().hashCode());
        result = prime * result + ((getPromotesSalesActivelyScore() == null) ? 0 : getPromotesSalesActivelyScore().hashCode());
        result = prime * result + ((getHasPromotionGiftsScore() == null) ? 0 : getHasPromotionGiftsScore().hashCode());
        result = prime * result + ((getSellsNonWangxiaoluProductsScore() == null) ? 0 : getSellsNonWangxiaoluProductsScore().hashCode());
        result = prime * result + ((getPromotionActivityContent() == null) ? 0 : getPromotionActivityContent().hashCode());
        result = prime * result + ((getHasGroundStack() == null) ? 0 : getHasGroundStack().hashCode());
        result = prime * result + ((getHasBlackDuckDisplay() == null) ? 0 : getHasBlackDuckDisplay().hashCode());
        result = prime * result + ((getHasBlackDuckTasting() == null) ? 0 : getHasBlackDuckTasting().hashCode());
        result = prime * result + ((getOtherBrandHasTastingTable() == null) ? 0 : getOtherBrandHasTastingTable().hashCode());
        result = prime * result + ((getPedestrianCountWithin10min() == null) ? 0 : getPedestrianCountWithin10min().hashCode());
        result = prime * result + ((getTotalTastingProductCount() == null) ? 0 : getTotalTastingProductCount().hashCode());
        result = prime * result + ((getTastingProductCountByFlavor() == null) ? 0 : getTastingProductCountByFlavor().hashCode());
        result = prime * result + ((getOtherBrandTastingTableProofUrl() == null) ? 0 : getOtherBrandTastingTableProofUrl().hashCode());
        result = prime * result + ((getNonWangxiaoluSalesProofUrl() == null) ? 0 : getNonWangxiaoluSalesProofUrl().hashCode());
        result = prime * result + ((getStorePicture() == null) ? 0 : getStorePicture().hashCode());
        result = prime * result + ((getTemWorkPhotos() == null) ? 0 : getTemWorkPhotos().hashCode());
        result = prime * result + ((getStoreTcPhoto() == null) ? 0 : getStoreTcPhoto().hashCode());
        result = prime * result + ((getStoreZhiPhoto() == null) ? 0 : getStoreZhiPhoto().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", id=").append(id);
        sb.append(", planId=").append(planId);
        sb.append(", depQcOrgName=").append(depQcOrgName);
        sb.append(", dealerId=").append(dealerId);
        sb.append(", dealerName=").append(dealerName);
        sb.append(", storeCode=").append(storeCode);
        sb.append(", storeName=").append(storeName);
        sb.append(", addr=").append(addr);
        sb.append(", pattern=").append(pattern);
        sb.append(", inspectionDate=").append(inspectionDate);
        sb.append(", inspectionTime=").append(inspectionTime);
        sb.append(", leaveStoreTime=").append(leaveStoreTime);
        sb.append(", onDutyStatus=").append(onDutyStatus);
        sb.append(", onDutyRate=").append(onDutyRate);
        sb.append(", onDutyCount=").append(onDutyCount);
        sb.append(", isOnDuty=").append(isOnDuty);
        sb.append(", offDutyCallTime=").append(offDutyCallTime);
        sb.append(", isCallConnected=").append(isCallConnected);
        sb.append(", isReconnectedAfter5min=").append(isReconnectedAfter5min);
        sb.append(", isBackToWorkWithin10min=").append(isBackToWorkWithin10min);
        sb.append(", totalScore=").append(totalScore);
        sb.append(", salesAssessmentScore=").append(salesAssessmentScore);
        sb.append(", promotionAssessmentScore=").append(promotionAssessmentScore);
        sb.append(", hasSchedulePromotionScore=").append(hasSchedulePromotionScore);
        sb.append(", groundStackHasMainProductScore=").append(groundStackHasMainProductScore);
        sb.append(", groundStackOnlyWangxiaoluScore=").append(groundStackOnlyWangxiaoluScore);
        sb.append(", groundStackStockFullScore=").append(groundStackStockFullScore);
        sb.append(", hasPromotionMaterialsScore=").append(hasPromotionMaterialsScore);
        sb.append(", wearsWangxiaoluApronScore=").append(wearsWangxiaoluApronScore);
        sb.append(", hasTastingProductScore=").append(hasTastingProductScore);
        sb.append(", hasTastingTableScore=").append(hasTastingTableScore);
        sb.append(", hasTastingPlateScore=").append(hasTastingPlateScore);
        sb.append(", hasTastingCupScore=").append(hasTastingCupScore);
        sb.append(", wearsMaskGlovesScore=").append(wearsMaskGlovesScore);
        sb.append(", hasToothpickBonusScore=").append(hasToothpickBonusScore);
        sb.append(", hasGarbageCanBonusScore=").append(hasGarbageCanBonusScore);
        sb.append(", knowsDistanceSolicitSkillScore=").append(knowsDistanceSolicitSkillScore);
        sb.append(", knowsProductSellingPointsScore=").append(knowsProductSellingPointsScore);
        sb.append(", greetsCustomersActivelyScore=").append(greetsCustomersActivelyScore);
        sb.append(", introducesProductScoresScore=").append(introducesProductScoresScore);
        sb.append(", promotesSalesActivelyScore=").append(promotesSalesActivelyScore);
        sb.append(", hasPromotionGiftsScore=").append(hasPromotionGiftsScore);
        sb.append(", sellsNonWangxiaoluProductsScore=").append(sellsNonWangxiaoluProductsScore);
        sb.append(", promotionActivityContent=").append(promotionActivityContent);
        sb.append(", hasGroundStack=").append(hasGroundStack);
        sb.append(", hasBlackDuckDisplay=").append(hasBlackDuckDisplay);
        sb.append(", hasBlackDuckTasting=").append(hasBlackDuckTasting);
        sb.append(", otherBrandHasTastingTable=").append(otherBrandHasTastingTable);
        sb.append(", pedestrianCountWithin10Min=").append(pedestrianCountWithin10min);
        sb.append(", totalTastingProductCount=").append(totalTastingProductCount);
        sb.append(", tastingProductCountByFlavor=").append(tastingProductCountByFlavor);
        sb.append(", otherBrandTastingTableProofUrl=").append(otherBrandTastingTableProofUrl);
        sb.append(", nonWangxiaoluSalesProofUrl=").append(nonWangxiaoluSalesProofUrl);
        sb.append(", storePicture=").append(storePicture);
        sb.append(", temWorkPhotos=").append(temWorkPhotos);
        sb.append(", storeTcPhoto=").append(storeTcPhoto);
        sb.append(", storeZhiPhoto=").append(storeZhiPhoto);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}