package com.wangxiaolu.promotion.pojo.user.vo;

import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.result.basedata.RCode;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

/**
 * @author : liqiulin
 * @date : 2024-03-28 18
 * @describe : 接收用
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
public class UserLoginParam {

    String loginName;
    String password;

    /**
     * 1, 'oneself', '个人权限'
     * 2, 'admin', '超管权限'
     */
    Integer privilegeId;

    /**
     * 0正常 1停用
     */
    private String status;

    public void validate(){
        if (StringUtils.isAnyBlank(loginName,password)){
            throw new ParamException(RCode.LOGIN_PARAM_ERROR,null);
        }
    }

    public void valLoginName(){
        if (StringUtils.isBlank(loginName)){
            throw new ParamException(RCode.LOGIN_PARAM_ERROR,null);
        }
    }
}
