package com.wangxiaolu.promotion.pojo.activity.manage.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 
 * @TableName employee_activity_plan_info
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Accessors(chain = true)
public class EmployeeActivityPlanInfoDto implements Serializable {
    /**
     * 主键id
     */
    private Long id;

    private List<Long> ids;

    /**
     * 活动计划表上传记录id
     */
    private Long activityPlanRecordId;

    /**
     * 文件ID（云存储中的id）
     */
    private String excelFiledId;

    /**
     * manage_employee_info表id
     */
    private Integer employeeId;

    /**
     * 姓名
     */
    private String employeeName;

    /**
     * 员工工号
     */
    private String employeeNo;

    /**
     * 活动月份YYYY-MM
     */
    private String activityMonth;

    /**
     * 城市
     */
    private String city;

    /**
     * 经销商编码
     */
    private String dealerId;

    /**
     * 经销商名称
     */
    private String dealerName;

    /**
     * 系统名称
     */
    private String lineName;

    /**
     * 店铺名称
     */
    private String storeName;

    /**
     * 活动模式
     */
    private String activityPattern;
    private Integer activityPatternId;

    private Integer activityStatus;

    /**
     * 1:有效；0：删除；
     */
    private Integer isDelete;

    private static final long serialVersionUID = 1L;
}