package com.wangxiaolu.promotion.domain.user.dao.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.wangxiaolu.promotion.domain.user.dao.QinCeClienteleShopDao;
import com.wangxiaolu.promotion.domain.user.mapper.QinCeClienteleShopMapper;
import com.wangxiaolu.promotion.domain.user.mapper.entity.QinCeClienteleShopDO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-22 16
 * @describe :
 */
@Slf4j
@Service
public class QinCeClienteleShopDaoImpl implements QinCeClienteleShopDao {

    @Autowired
    QinCeClienteleShopMapper qinCeClienteleShopMapper;

    @Override
    public void shopDetailAllTask(JSONArray responseDatas) {
        LambdaQueryWrapper<QinCeClienteleShopDO> qw = new LambdaQueryWrapper<>();

        for (Object responseData : responseDatas) {
            qw.clear();

            QinCeClienteleShopDO qinCeShopDO = JSONObject.parseObject(responseData.toString(), QinCeClienteleShopDO.class);
            qw.eq(QinCeClienteleShopDO::getQcId, qinCeShopDO.getQcId());
            QinCeClienteleShopDO doExist = qinCeClienteleShopMapper.selectOne(qw);

            if (Objects.isNull(doExist)) {
                qinCeClienteleShopMapper.insert(qinCeShopDO);
            } else {
                qinCeShopDO.setId(doExist.getId());
                qinCeClienteleShopMapper.updateById(qinCeShopDO);
            }
        }

    }
}
