package com.wangxiaolu.promotion.domain.activity.dao.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.druid.util.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityReportedDao;
import com.wangxiaolu.promotion.domain.activity.mapper.TemporaryActivityReportedMapper;
import com.wangxiaolu.promotion.domain.activity.mapper.entity.TemporaryActivityReportedDO;
import com.wangxiaolu.promotion.domain.activity.mapper.wrapperQo.TemporaryActivityWrapper;
import com.wangxiaolu.promotion.enums.activity.TemActApproveStatus;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityReportedDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-18 10
 * @describe :
 */
@Service
@Slf4j
public class TemporaryActivityReportedDaoImpl implements TemporaryActivityReportedDao {

    @Autowired
    TemporaryActivityReportedMapper temporaryActivityReportedMapper;

    /**
     * 保存促销员任务
     */
    @Override
    public long activityDataSave(TemporaryActivityReportedDto temActDto) {

        TemporaryActivityReportedDO tDo = new TemporaryActivityReportedDO();
        BeanUtils.copyProperties(temActDto, tDo);

        tDo.setApproveStatus(temActDto.getApproveStatus().name());
        tDo.setCreateDate(DateUtil.today());

        int tId = temporaryActivityReportedMapper.insert(tDo);
        log.info("促销员今日活动上报数据完成，生成id[{}]，数据信息：{}", tId, tDo);
        return tId;
    }

    /**
     * 根据促销员id查询所有任务
     */
    @Override
    public List<TemporaryActivityReportedDto> findListByTemporaryId(Long temporaryId) {
        TemporaryActivityWrapper taw = new TemporaryActivityWrapper()
                .setTemporaryId(temporaryId);
        LambdaQueryWrapper<TemporaryActivityReportedDO> temQw = buildQueryList(taw);
        List<TemporaryActivityReportedDO> temDOS = temporaryActivityReportedMapper.selectList(temQw);
        return transitionDtos(temDOS);
    }

    /**
     * 根据促销员id查询今日任务
     */
    @Override
    public TemporaryActivityReportedDto findOneByCurrentDate(Long temporaryId) {
        TemporaryActivityWrapper taw = new TemporaryActivityWrapper()
                .setTemporaryId(temporaryId)
                .setCreateDate(DateUtil.today());
        LambdaQueryWrapper<TemporaryActivityReportedDO> temQw = buildQueryList(taw);
        TemporaryActivityReportedDO temDO = temporaryActivityReportedMapper.selectOne(temQw);
        return transitionDto(temDO);
    }

    @Override
    public TemporaryActivityReportedDto findTemporaryActivityById(Long activityId) {
        TemporaryActivityReportedDO temDO = temporaryActivityReportedMapper.selectById(activityId);
        return transitionDto(temDO);
    }


    private LambdaQueryWrapper<TemporaryActivityReportedDO> buildQueryList(TemporaryActivityWrapper tw) {
        LambdaQueryWrapper<TemporaryActivityReportedDO> queryWrapper = new LambdaQueryWrapper<>();
        if (Objects.nonNull(tw.getTemporaryId())) {
            queryWrapper.eq(TemporaryActivityReportedDO::getTemporaryId, tw.getTemporaryId());
        }
        if (!StringUtils.isEmpty(tw.getCreateDate())) {
            queryWrapper.eq(TemporaryActivityReportedDO::getCreateDate, tw.getCreateDate());
        }
        return queryWrapper;
    }

    /**
     * DO to DTO (单个对象)
     *
     * @param temDos DO对象List
     * @return DTO对象
     */
    private List<TemporaryActivityReportedDto> transitionDtos(List<TemporaryActivityReportedDO> temDos) {
        if (CollectionUtils.isEmpty(temDos)) {
            return new ArrayList<>();
        }

        List<TemporaryActivityReportedDto> dtos = new ArrayList<>(temDos.size() * 2);
        for (TemporaryActivityReportedDO temDo : temDos) {
            dtos.add(transitionDto(temDo));
        }
        return dtos;
    }

    /**
     * DO to DTO (单个对象)
     *
     * @param temDo DO对象
     * @return DTO对象
     */
    private TemporaryActivityReportedDto transitionDto(TemporaryActivityReportedDO temDo) {
        TemporaryActivityReportedDto temporaryDto = null;
        if (Objects.isNull(temDo)) {
            return temporaryDto;
        }

        temporaryDto = new TemporaryActivityReportedDto();
        BeanUtils.copyProperties(temDo, temporaryDto);
        // 审批状态回显
        if (Objects.nonNull(temDo.getApproveStatus())) {
            temporaryDto.setApproveStatus(TemActApproveStatus.valueOf(temDo.getApproveStatus()));
            temporaryDto.setApproveStatusMsg(temporaryDto.getApproveStatus().getMsg());
        }
        return temporaryDto;
    }
}
