package com.wangxiaolu.promotion.utils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.result.basedata.RCode;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * @author : liqiulin
 * @date : 2024-04-16 17
 * @describe : java web token
 */
@Slf4j
@Component
public class JwtUtils {


    /**
     * 促销员-解密秘钥
     */
    @Value("${wx.miniapp.temporary.token_secret}")
    private String TEMPORARY_SECRET;

    public String getTemporaryToken(String openId, String phone) {
        try {
            //用秘钥生成签名
            Algorithm algorithm = Algorithm.HMAC256(TEMPORARY_SECRET);
            //默认头部+载荷（手机号/id）+签名=jwt
            String jwtToken = JWT.create()
                    .withClaim("openId", openId)
                    .withClaim("phone", phone)
                    .sign(algorithm);
            return jwtToken;
        } catch (Exception e) {
            log.error("用户{}的token生成异常：{}", openId, e);
            throw new ParamException(RCode.LOGIN_PARAM_ERROR, e.getMessage());
        }
    }

    /**
     * 校验token是否正确
     **/
    public boolean verifyTemporaryToken(String token,String openId, String phone) {
        try {
            // 生成JWT效验器
            Algorithm algorithm = Algorithm.HMAC256(TEMPORARY_SECRET);
            JWTVerifier verifier = JWT.require(algorithm).build();
            verifier.verify(token);
            return true;
//            DecodedJWT jwt = JWT.decode(token);
//            if (
//                    openId.equals(jwt.getClaim("openId").asString())
//                    && phone.equals(jwt.getClaim("phone").asString())
//            ){
//                return true;
//            }
//            return false;
        } catch (Exception e) {
            log.error("用户{}的token解析异常：{}", openId, e);
            throw new ParamException(RCode.LOGIN_PARAM_ERROR, e.getMessage());
        }
    }
}
