package com.wangxiaolu.promotion.domain.manage.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wangxiaolu.promotion.common.enums.StatusType;
import com.wangxiaolu.promotion.common.util.NumberUtils;
import com.wangxiaolu.promotion.domain.manage.dao.EmployeeActivityPlanInfoDao;
import com.wangxiaolu.promotion.domain.manage.mapper.EmployeeActivityPlanInfoMapper;
import com.wangxiaolu.promotion.domain.manage.mapper.entity.EmployeeActivityPlanInfoDO;
import com.wangxiaolu.promotion.domain.manage.wrapperQo.ActivityPlanInfoWrapper;
import com.wangxiaolu.promotion.exception.DataException;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.activity.manage.dto.EmployeeActivityPlanInfoDto;
import com.wangxiaolu.promotion.result.basedata.RCode;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-08-29 13
 * @describe :
 */
@Service
public class EmployeeActivityPlanInfoDaoImpl implements EmployeeActivityPlanInfoDao {
    @Autowired
    EmployeeActivityPlanInfoMapper employeeActivityPlanInfoMapper;

    @Override
    public void saveList(List<EmployeeActivityPlanInfoDto> planInfoDtos) {
        List<EmployeeActivityPlanInfoDO> dos = new ArrayList<>(planInfoDtos.size() * 2);
        Date createTime = new Date();
        planInfoDtos.stream().forEach(dto -> {
            EmployeeActivityPlanInfoDO infoDo = new EmployeeActivityPlanInfoDO();
            BeanUtils.copyProperties(dto, infoDo);
            infoDo.setCreateTime(createTime);
            dos.add(infoDo);
        });

        employeeActivityPlanInfoMapper.saveList(dos);
    }

    @Override
    public void page(PageInfo pageInfo, ActivityPlanInfoWrapper wrapper) {
        LambdaQueryWrapper<EmployeeActivityPlanInfoDO> qw = buildWrapper(wrapper);
        Page<EmployeeActivityPlanInfoDO> page = new Page<>(pageInfo.getPageNum(), pageInfo.getPageSize());
        Page<EmployeeActivityPlanInfoDO> doPage = employeeActivityPlanInfoMapper.selectPage(page, qw);

        pageInfo.pageCovert(doPage);
        // 目前没有返回到service处理逻辑，所以不需要转dto
        pageInfo.setRecords(doPage.getRecords());
    }

    @Override
    public void deletebyActivityPlanRecordId(Long recordId) {
        employeeActivityPlanInfoMapper.deletebyActivityPlanRecordId(recordId);
    }

    @Override
    public void update(ActivityPlanInfoWrapper wrap) {
        LambdaQueryWrapper<EmployeeActivityPlanInfoDO> qw = buildUpdateWrapper(wrap);
        EmployeeActivityPlanInfoDO updateDO = new EmployeeActivityPlanInfoDO();
        updateDO.setActivityStatus(wrap.getActivityStatusUpdate().getType());
        employeeActivityPlanInfoMapper.update(updateDO,qw);
    }

    private LambdaQueryWrapper<EmployeeActivityPlanInfoDO> buildWrapper(ActivityPlanInfoWrapper wrapper) {
        LambdaQueryWrapper<EmployeeActivityPlanInfoDO> qw = new LambdaQueryWrapper<>();
        if (Objects.nonNull(wrapper.getEmployeeId())) {
            qw.eq(EmployeeActivityPlanInfoDO::getEmployeeId, wrapper.getEmployeeId());
        }

        if (Objects.nonNull(wrapper.getActivityPlanRecordId())) {
            qw.eq(EmployeeActivityPlanInfoDO::getActivityPlanRecordId, wrapper.getActivityPlanRecordId());
        }

        if (StringUtils.isNotBlank(wrapper.getExcelFiledId())) {
            qw.eq(EmployeeActivityPlanInfoDO::getExcelFiledId, wrapper.getExcelFiledId());
        }

        if (StringUtils.isNotBlank(wrapper.getActivityMonth())) {
            qw.eq(EmployeeActivityPlanInfoDO::getActivityMonth, wrapper.getActivityMonth());
        }

        if (StringUtils.isNotBlank(wrapper.getDealerName())) {
            qw.like(EmployeeActivityPlanInfoDO::getDealerName, wrapper.getDealerName());
        }

        if (StringUtils.isNotBlank(wrapper.getCity())) {
            qw.like(EmployeeActivityPlanInfoDO::getCity, wrapper.getCity());
        }

        if (StringUtils.isNotBlank(wrapper.getStoreName())) {
            qw.like(EmployeeActivityPlanInfoDO::getStoreName, wrapper.getStoreName());
        }

        if (Objects.nonNull(wrapper.getActivityStatus())){
            qw.eq(EmployeeActivityPlanInfoDO::getActivityStatus,wrapper.getActivityStatus().getType());
        }

        qw.eq(EmployeeActivityPlanInfoDO::getIsDelete, StatusType.VALID.getType());
        qw.orderByDesc(EmployeeActivityPlanInfoDO::getCreateTime);
        return qw;
    }


    private LambdaQueryWrapper<EmployeeActivityPlanInfoDO> buildUpdateWrapper(ActivityPlanInfoWrapper wrapper) {
        LambdaQueryWrapper<EmployeeActivityPlanInfoDO> qw = new LambdaQueryWrapper<>();
        if (!CollectionUtils.isEmpty(wrapper.getIds())) {
            qw.in(EmployeeActivityPlanInfoDO::getId,wrapper.getIds());
        }
        if (!NumberUtils.isNull(wrapper.getId())){
            qw.eq(EmployeeActivityPlanInfoDO::getId,wrapper.getId());
        }

        if (qw.isEmptyOfWhere()){
           throw new ParamException(RCode.SELECT_PARAMS_ERROR,null);
        }
        return qw;
    }
}
