package com.wangxiaolu.promotion.service.activity.temporary.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.wangxiaolu.promotion.common.util.BeanUtils;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityPhotoDao;
import com.wangxiaolu.promotion.domain.activity.mapper.TemporaryActivityTaskClockMapper;
import com.wangxiaolu.promotion.domain.activity.mapper.entity.TemporaryActivityTaskClockDO;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityTaskClockDao;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryActivityTaskWrapperDto;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryPhotoWrapper;
import com.wangxiaolu.promotion.enums.activity.ActivityClockTaskStatus;
import com.wangxiaolu.promotion.enums.activity.ActivityPhotoType;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityPhotoDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.res.TemporaryActivityTaskClockRes;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryClockDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.vo.TemporaryActivityTaskClockReq;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityTaskClockService;
import com.wangxiaolu.promotion.utils.AuthUtils;
import com.wangxiaolu.promotion.utils.DateUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalTime;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;

@Service
public class TemporaryActivityTaskClockServiceImpl extends ServiceImpl<TemporaryActivityTaskClockMapper, TemporaryActivityTaskClockDO> implements TemporaryActivityTaskClockService {

    @Resource
    private TemporaryActivityTaskClockDao temporaryActivityTaskClockDao;
    @Resource
    private TemporaryActivityPhotoDao photoDao;

    @Override
    public List<TemporaryActivityTaskClockDO> listByTemporaryId(Integer temporaryId) {
        TemporaryActivityTaskWrapperDto wrapper = new TemporaryActivityTaskWrapperDto()
                .setTemporaryId(temporaryId)
                .setIsDelete(1);
        // 过滤未删除数据
        return temporaryActivityTaskClockDao.selectList(wrapper);
    }

    @Override
    public void generateRandomClockTask(TemporaryClockDto dto) {
        // 随机生成 下午5:30～7:30 之间的Date
        LocalTime randomTime = LocalTime.of(17, 30, 0).plusMinutes(ThreadLocalRandom.current().nextInt(0, 120));

        Date randomDate = DateUtils.parseDateByLocalTime(randomTime);
        // 生成
        TemporaryActivityTaskClockDO taskClockDO = TemporaryActivityTaskClockDO.builder()
                .temporaryId(dto.getTemporaryId())
                .clockId(dto.getId())
                .temporaryName(dto.getTemporaryName())
                .reportedId(dto.getReportedId())
                .planId(dto.getPlanId())
                .clockTime(null)
                .taskType(ActivityPhotoType.RANDOM_TASK.getType())
                .taskStatus(ActivityClockTaskStatus.STARTING.getType())
                .requiredlockTime(randomDate)
                .activityPatternId(dto.getActivityPatternId())
                .activityPattern(dto.getActivityPattern())
                .isDelete(1)
                .build();
        temporaryActivityTaskClockDao.save(taskClockDO);

    }

    @Override
    public void generatePosUploadTask(TemporaryClockDto dto) {
        // 生成
        TemporaryActivityTaskClockDO taskClockDO = TemporaryActivityTaskClockDO.builder()
                .temporaryId(dto.getTemporaryId())
                .clockId(dto.getId())
                .temporaryName(dto.getTemporaryName())
                .reportedId(dto.getReportedId())
                .planId(dto.getPlanId())
                .clockTime(null)
                .taskType(ActivityPhotoType.POS_PHOTO.getType())
                .taskStatus(ActivityClockTaskStatus.TO_BE_START.getType())
                .requiredlockTime(DateUtil.endOfDay(new Date()))
                .activityPatternId(dto.getActivityPatternId())
                .activityPattern(dto.getActivityPattern())
                .isDelete(1)
                .build();
        temporaryActivityTaskClockDao.save(taskClockDO);
    }

    @Override
    public List<TemporaryActivityTaskClockDO> listByUserId() {
        // 从header获取token标识
        String token = AuthUtils.getToken();
        String userId = AuthUtils.getUserId(token);
        TemporaryActivityTaskWrapperDto wrapper = new TemporaryActivityTaskWrapperDto()
                .setUserId(Long.parseLong(userId))
                .setTemporaryId(Integer.parseInt(userId))
                .setIsDelete(1);
        List<TemporaryActivityTaskClockDO> list = temporaryActivityTaskClockDao.selectList(wrapper);
        return list;
    }

    @Override
    public void clock(TemporaryActivityTaskClockReq clockVo) {
        TemporaryActivityTaskClockDO taskClockDO = temporaryActivityTaskClockDao.selectById(clockVo.getId());
        if (taskClockDO == null) {
            throw new IllegalArgumentException("打卡任务不存在");
        }
        // 随机打卡
        if (ActivityPhotoType.RANDOM_TASK.getType() == clockVo.getTaskType()) {
            // 检查当前时间是否在打卡要求的时间内
            Date requiredLockTime = taskClockDO.getRequiredlockTime();
            DateTime latestRequiredLockTime = DateUtil.offsetMinute(requiredLockTime, 15);
            if (new Date().before(requiredLockTime) || new Date().after(latestRequiredLockTime)) {
                throw new IllegalArgumentException("当前时间不在打卡要求的时间内");
            }
        }
        BeanUtils.copyProperties(clockVo, taskClockDO);

        // 更新 任务状态为未完成，打卡时间为当前时间
        taskClockDO.setTaskStatus(ActivityClockTaskStatus.UNCOMPLETED.getType());
        taskClockDO.setClockTime(new Date());
        temporaryActivityTaskClockDao.update(taskClockDO);

        TemporaryActivityPhotoDto dto = new TemporaryActivityPhotoDto();
        dto.setClockId(taskClockDO.getId())
                .setTemporaryId(taskClockDO.getTemporaryId())
                .setReportedId(taskClockDO.getReportedId())
                .setType(clockVo.getTaskType());
        // 保存打卡图片
        photoDao.saveClockTaskPhoto(dto,clockVo.getClockPhotos());
    }

    @Override
    public TemporaryActivityTaskClockRes queryByMyTaskType(Integer taskType) {
        // 从header获取token标识
        String token = AuthUtils.getToken();
        String userId = AuthUtils.getUserId(token);
        TemporaryActivityTaskWrapperDto wrapper = new TemporaryActivityTaskWrapperDto()
                .setUserId(Long.parseLong(userId))
                .setTaskType(taskType)
                .setTemporaryId(Integer.parseInt(userId))
                .setIsDelete(1);
        TemporaryActivityTaskClockDO  taskClockDO = temporaryActivityTaskClockDao.selectOne(wrapper);
        TemporaryActivityTaskClockRes res = new TemporaryActivityTaskClockRes();
        if (taskClockDO != null) {
            BeanUtils.copyProperties(taskClockDO, res);
            // 查询图片
            TemporaryPhotoWrapper photoWrapper = new TemporaryPhotoWrapper()
                    .setReportedId(taskClockDO.getReportedId())
                    .setTemporaryId(taskClockDO.getTemporaryId());
             List<TemporaryActivityPhotoDto> photoDtos = photoDao.selectPhotos(photoWrapper);
            List<String> photoUrls = photoDtos.stream()
                    .filter(photoDto -> photoDto.getType().equals(taskType))
                    .map(TemporaryActivityPhotoDto::getPhotoUrl)
                    .collect(Collectors.toList());
            res.setClockPhtos(photoUrls);
            return res;
        }
        return res;
    }


}
