package com.wangxiaolu.promotion.controller.activity.temporary;

import com.wangxiaolu.promotion.domain.activity.mapper.entity.TemporaryActivityTaskClockDO;
import com.wangxiaolu.promotion.pojo.activity.temporary.res.TemporaryActivityTaskClockRes;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityTaskClockService;
import org.springframework.web.bind.annotation.*;
import javax.annotation.Resource;
import java.util.List;

/**
 * @author lvbencai
 * @date 2025年11月11日16:45:27
 * @description: 临时活动任务打卡查询控制层
 */
@RestController
@RequestMapping("/activity/task-clock/query")
public class TemporaryActivityTaskClockQueryController {

    @Resource
    private TemporaryActivityTaskClockService service;

    @GetMapping("/byId/{id}")
    public TemporaryActivityTaskClockDO getById(@PathVariable Long id) {
        return service.getById(id);
    }

    /**
     * 查询任务打卡列表
     *
     * @return
     */
    @GetMapping("/list")
    public List<TemporaryActivityTaskClockDO> listByTemporaryId() {
        return service.listByUserId();
    }



    /**
     * 按照任务类型查询任务信息
     *
     * @return
     */
    @GetMapping("/my/{taskType}")
    public TemporaryActivityTaskClockRes queryByMyTaskType(@PathVariable Integer taskType) {
        return service.queryByMyTaskType(taskType);
    }

}
