package com.wangxiaolu.promotion.service.activity.temporary.impl;

import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityClockDao;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityPhotoDao;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityReportedDao;
import com.wangxiaolu.promotion.domain.user.dao.QinCeClienteleStoreDao;
import com.wangxiaolu.promotion.domain.user.wrapperQo.StoreWrapper;
import com.wangxiaolu.promotion.enums.activity.ActivityPhotoType;
import com.wangxiaolu.promotion.enums.activity.TemActApproveStatus;
import com.wangxiaolu.promotion.exception.FlowException;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityReportedDto;
import com.wangxiaolu.promotion.pojo.user.dto.QinCeClienteleStoreDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryClockDto;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityCoreService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-18 11
 * @describe :
 */
@Service
@Slf4j
public class TemporaryActivityCoreServiceImpl implements TemporaryActivityCoreService {

    @Autowired
    private TemporaryActivityReportedDao temporaryActivityReportedDao;

    @Autowired
    private TemporaryActivityClockDao temporaryActivityClockDao;

    @Autowired
    private QinCeClienteleStoreDao qinCeClienteleStoreDao;

    @Autowired
    private TemporaryActivityPhotoDao tempActivityPhotoDao;


    /**
     * 活动上报保存
     *
     * @return 生成id
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public long activityDataReportedSave(TemporaryActivityReportedDto temActDto) {
        /**
         * 判断是否已存在上报数据
         */
        TemporaryActivityReportedDto haveDate = temporaryActivityReportedDao.findOneByCurrentDate(temActDto.getTemporaryId());
        if (Objects.nonNull(haveDate)) {
            throw new FlowException(RCode.DATA_HAVE_ERROR, null);
        }

        temActDto.setApproveStatus(TemActApproveStatus.SUBMITTED);

        // 根据storeQcId查询店铺信息
        QinCeClienteleStoreDto storeDto = qinCeClienteleStoreDao.getOneStore(new StoreWrapper().setQcId(temActDto.getStoreQcId()));
        temActDto.setStoreName(storeDto.getStoreName()).setStoreAddr(storeDto.getStoreAddr());

        // 保存活动数据 temporary_activity_reported
        long reportedId = temporaryActivityReportedDao.activityDataSave(temActDto);
        temActDto.setId(reportedId);
        /**
         * 保存图片
         */
        saveActivityPhoto(temActDto);
        return reportedId;
    }

    /**
     * 活动信息修改
     * 1、判断活动是否可以修改
     */
    @Override
    public void activityDataReportedUpdate(TemporaryActivityReportedDto temActDto) {
        // 图片增量保存
        saveActivityPhoto(temActDto);
        temporaryActivityReportedDao.updateById(temActDto);
    }

    /**
     * 促销员当日打卡信息保存
     */
    @Override
    public void clockInTodayActivity(TemporaryClockDto dto) {
        if (Objects.isNull(dto.getId())) {
            temporaryActivityClockDao.save(dto);
            return;
        }
        temporaryActivityClockDao.updateById(dto);
    }

    private void saveActivityPhoto(TemporaryActivityReportedDto temActDto) {
        Integer temporaryId = temActDto.getTemporaryId();
        Long reportedId = temActDto.getId();
        // 推广试吃照片
        if (!CollectionUtils.isEmpty(temActDto.getTgscPhotoUrls())) {
            tempActivityPhotoDao.saveReportedList(temporaryId, reportedId, ActivityPhotoType.tgsc.getType(), temActDto.getTgscPhotoUrls(), temActDto.getTgscChangePhotoUrls());
        }

        // 推广互动照片
        if (!CollectionUtils.isEmpty(temActDto.getTghdPhotoUrls())) {
            tempActivityPhotoDao.saveReportedList(temporaryId, reportedId, ActivityPhotoType.tghd.getType(), temActDto.getTghdPhotoUrls(), temActDto.getTghdChangePhotoUrls());
        }

        // 推广成交照片
        if (!CollectionUtils.isEmpty(temActDto.getTgcjPhotoUrls())) {
            tempActivityPhotoDao.saveReportedList(temporaryId, reportedId, ActivityPhotoType.tgcj.getType(), temActDto.getTgcjPhotoUrls(), temActDto.getTgcjChangePhotoUrls());
        }
        log.info("促销员今日活动上报-图片保存成功，关联活动上报数据id[{}]，数据信息：{}", temActDto.getId(), temActDto);

    }

}
