package com.wangxiaolu.promotion.service.activity.temporary.impl;

import cn.hutool.core.date.DateUtil;
import com.wangxiaolu.promotion.domain.activity.dao.TemporaryActivityClockDao;
import com.wangxiaolu.promotion.domain.activity.wrapperQo.TemporaryClockWrapper;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryClockDto;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityClockQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2024-04-23 19
 * @describe :
 */
@Slf4j
@Service
public class TemporaryActivityClockQueryServiceImpl implements TemporaryActivityClockQueryService {

    @Autowired
    TemporaryActivityClockDao temporaryActivityClockDao;

    @Override
    public TemporaryClockDto findTodayTemporaryClockByTemId(Integer temporaryId) {
        String today = DateUtil.today();
        TemporaryClockWrapper tcw = new TemporaryClockWrapper()
                .setTemporaryId(temporaryId)
                .setCreateDate(today);

        return temporaryActivityClockDao.selectOne(tcw);
    }

    /**
     * 查询指定日期打卡信息
     */
    @Override
    public TemporaryClockDto findTemporaryClockByTemIdAndDate(Integer temporaryId, String createDate) {
        TemporaryClockWrapper tcw = new TemporaryClockWrapper()
                .setTemporaryId(temporaryId)
                .setCreateDate(createDate);
        return temporaryActivityClockDao.selectOne(tcw);
    }
}
