package com.wangxiaolu.promotion.domain.user.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wangxiaolu.promotion.domain.user.dao.QinceDealerDao;
import com.wangxiaolu.promotion.domain.user.mapper.QinceDealerMapper;
import com.wangxiaolu.promotion.domain.user.mapper.entity.QinceDealerDO;
import com.wangxiaolu.promotion.pojo.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.rmi.server.ObjID;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-08-27 19
 * @describe :
 */
@Slf4j
@Service
public class QinceDealerDaoImpl implements QinceDealerDao {

    @Autowired
    QinceDealerMapper qinceDealerMapper;

    @Override
    public void saveList(List<Object> dealerJsons) {
        // 目前没有查重逻辑，只在前边判断逻辑中进行新增
        qinceDealerMapper.saveList(dealerJsons);
        log.info("勤策同步经销商，新增数量：{}",dealerJsons.size());
    }

    @Override
    public void page(PageInfo pageInfo) {
        Map queryParams = pageInfo.getQueryParams();
        LambdaQueryWrapper<QinceDealerDO> qw = new LambdaQueryWrapper<>();
        if (!CollectionUtils.isEmpty(queryParams)) {
            if (StringUtils.isNotBlank((String) queryParams.get("dealerId"))) {
                qw.eq(QinceDealerDO::getDealerId, queryParams.get("dealerId"));
            }
            if (StringUtils.isNotBlank((String) queryParams.get("dealerName"))) {
                qw.like(QinceDealerDO::getDealerName, queryParams.get("dealerName"));
            }
        }
        qw.select(QinceDealerDO::getDealerId, QinceDealerDO::getDealerName);
        Page<QinceDealerDO> page = new Page<>(pageInfo.getPageNum(), pageInfo.getPageSize());
        Page<QinceDealerDO> doPage = qinceDealerMapper.selectPage(page, qw);
        pageInfo.pageCovert(page);
        pageInfo.setRecords(doPage.getRecords());
    }

    @Override
    public Map<Object, Object> selectAll() {
        List<QinceDealerDO> qinceDealerDOS = qinceDealerMapper.selectList(null);
        Map<Object,Object> maps = new HashMap<>(qinceDealerDOS.size()*2);

        qinceDealerDOS.forEach(qinceDealerDO -> {
            maps.put(qinceDealerDO.getDealerId(),qinceDealerDO.getDealerName());
        });
        return maps;
    }

}
