package com.wangxiaolu.promotion.pojo.activity.temporary.dto;

import com.wangxiaolu.promotion.enums.activity.TemActApproveStatus;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * @author : liqiulin
 * @date : 2024-04-18 10
 * @describe :
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
public class TemporaryActivityReportedDto {
    /**
     * temporary_activity_reported主键id
     */
    private Long id;

    /**
     * 关联—temporary_info表id
     */
    private Integer temporaryId;

    /**
     * 关联—temporary_info表name
     */
    private String temporaryName;

    /**
     * 关联—活动店铺id
     */
    private Long storeId;

    /**
     * 关联—活动店铺名称（例：小美超市）
     */
    private String storeName;

    /**
     * 关联—活动店铺地址（例：北京朝阳北路31号1层）
     */
    private String storeAddr;

    /**
     * 省份
     */
    private String province;

    /**
     * 城市
     */
    private String city;

    /**
     * 关联—审核人员qc_id
     *
     */
    private String approverId;

    /**
     * 关联—审核人员姓名
     */
    private String approveName;

    /**
     * 审批状态（审批中、审批通过、退回……）
     */
    private TemActApproveStatus approveStatus;

    private String approveStatusMsg;

    /**
     * 最后一次审批时间
     */
    private Date approveTime;

    /**
     * 退回原因
     */
    private String approveReason;

    /**
     * 推广试吃照片
     */
    List<String> tgscPhotoUrls;
    List<String> tgscChangePhotoUrls;

    /**
     * 推广互动照片
     */
    List<String> tghdPhotoUrls;
    List<String> tghdChangePhotoUrls;

    /**
     * 推广成交照片
     */
    List<String> tgcjPhotoUrls;
    List<String> tgcjChangePhotoUrls;

    /**
     * POS机页面凭证
     */
    private List<String> psvPhotoUrls;
    private List<String> psvChangePhotoUrls;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建日期
     */
    private String createDate;

    /**
     * 修改时间
     */
    private Date modifyTime;

    private List<TemporaryActivityMarketCellDto> marketCells;
}
