package com.wangxiaolu.promotion.domain.user.dao.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.wangxiaolu.promotion.domain.user.dao.QinceProductInfoDao;
import com.wangxiaolu.promotion.domain.user.mapper.QinceProductInfoMapper;
import com.wangxiaolu.promotion.domain.user.mapper.entity.QinceProductInfoDO;

import com.wangxiaolu.promotion.pojo.user.dto.QinceProductInfoDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-06-19 17
 * @describe :
 */
@Slf4j
@Service
public class QinceProductInfoDaoImpl implements QinceProductInfoDao {

    @Autowired
    QinceProductInfoMapper qinceProductInfoMapper;


    @Override
    public void productSyncTask(JSONArray responseDatas) {
        log.info("勤策-同步商品信息，共「{}」条数据", responseDatas.size());
        LambdaQueryWrapper<QinceProductInfoDO> qw = new LambdaQueryWrapper<>();

        for (Object responseData : responseDatas) {
            qw.clear();

            // 查询人员是否存在
            QinceProductInfoDO qcDo = JSONObject.parseObject(JSONObject.toJSONString(responseData), QinceProductInfoDO.class);
            qw.eq(QinceProductInfoDO::getPrdWaiqin365Id, qcDo.getPrdWaiqin365Id());
            QinceProductInfoDO doExist = qinceProductInfoMapper.selectOne(qw);

            // 存在则修改，不存在则添加
            if (Objects.isNull(doExist)) {
                qinceProductInfoMapper.insert(qcDo);
                log.info("勤策-[{}]商品信息不存在，已添加，qc_id：{}", qcDo.getPrdName(), qcDo.getPrdWaiqin365Id());
            } else {
                qcDo.setId(doExist.getId());
                qinceProductInfoMapper.updateById(qcDo);
                log.info("勤策--[{}]商品信息已存在，现已修改，qc_id：{}", qcDo.getPrdName(), qcDo.getPrdWaiqin365Id());
            }
        }

    }

    @Override
    public List<QinceProductInfoDto> selectList() {
        LambdaQueryWrapper<QinceProductInfoDO> qw = new LambdaQueryWrapper<>();
        qw.eq(QinceProductInfoDO::getSaleStatus,1).eq(QinceProductInfoDO::getStatus,1).ne(QinceProductInfoDO::getClassName,"")
                .select(QinceProductInfoDO::getClassId,QinceProductInfoDO::getClassName,QinceProductInfoDO::getPrdId,QinceProductInfoDO::getPrdName);

        List<QinceProductInfoDO> qinceProductInfoDOS = qinceProductInfoMapper.selectList(qw);
        return transitionDtos(qinceProductInfoDOS);
    }

    /**
     * DO to DTO (单个对象)
     *
     * @param productInfoDOS DO对象List
     * @return DTO对象
     */
    private List<QinceProductInfoDto> transitionDtos(List<QinceProductInfoDO> productInfoDOS) {
        if (CollectionUtils.isEmpty(productInfoDOS)) {
            return new ArrayList<>();
        }
        List<QinceProductInfoDto> dtos = new ArrayList<>(productInfoDOS.size() * 2);
        for (QinceProductInfoDO productInfoDO : productInfoDOS) {
            dtos.add(transitionDto(productInfoDO));
        }
        return dtos;
    }

    private QinceProductInfoDto transitionDto(QinceProductInfoDO productInfoDO) {
        QinceProductInfoDto dto = null;
        if (Objects.isNull(productInfoDO)) {
            return dto;
        }
        dto = new QinceProductInfoDto();
        BeanUtils.copyProperties(productInfoDO, dto);
        return dto;
    }

}
