package com.wangxiaolu.promotion.service.user.impl;

import com.wangxiaolu.promotion.common.redis.RedisKeys;
import com.wangxiaolu.promotion.common.redis.service.RedisCache;
import com.wangxiaolu.promotion.common.util.JwtUtils;
import com.wangxiaolu.promotion.domain.activity.dao.ManageEmployeeInfoDao;
import com.wangxiaolu.promotion.pojo.user.dto.ManageEmployeeInfoDto;
import com.wangxiaolu.promotion.pojo.user.vo.LoginVo;
import com.wangxiaolu.promotion.pojo.user.vo.UserLoginParam;
import com.wangxiaolu.promotion.service.user.WangxlEmployeeQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author : liqiulin
 * @date : 2024-05-29 13
 * @describe :
 */
@Service
@Slf4j
public class WangxlEmployeeQueryServiceImpl implements WangxlEmployeeQueryService {
    @Autowired
    RedisCache redisCache;
    @Autowired
    JwtUtils jwtUtils;
    @Autowired
    ManageEmployeeInfoDao manageEmployeeInfoDao;


    @Override
    public LoginVo employeeLoginVerify(UserLoginParam userLoginParam) {
        ManageEmployeeInfoDto employeeDto = manageEmployeeInfoDao.loginByEmployeeNo(userLoginParam.getLoginName(),userLoginParam.getPassword());

        String loginToken = jwtUtils.getEmployeeToken(userLoginParam.getLoginName(), userLoginParam.getPassword());
        redisCache.addToJsonToMinute(RedisKeys.UserKeys.TEMPORARY_TOKEN.getKey()+loginToken,employeeDto,360);

        LoginVo loginVo = new LoginVo<>(employeeDto,loginToken);
        return loginVo;

    }
}
