package com.wangxiaolu.promotion.domain.manage.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wangxiaolu.promotion.common.enums.StatusType;
import com.wangxiaolu.promotion.common.util.NumberUtils;
import com.wangxiaolu.promotion.domain.manage.dao.EmployeeActivityPlanRecordDao;
import com.wangxiaolu.promotion.domain.manage.mapper.EmployeeActivityPlanRecordMapper;
import com.wangxiaolu.promotion.domain.manage.mapper.entity.EmployeeActivityPlanRecordDO;
import com.wangxiaolu.promotion.domain.manage.wrapperQo.ActivityPlanRecordWrapper;
import com.wangxiaolu.promotion.exception.DataException;
import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.activity.manage.dto.EmployeeActivityPlanRecordDto;
import com.wangxiaolu.promotion.result.basedata.RCode;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-08-21 13
 * @describe :
 */
@Service
public class EmployeeActivityPlanRecordDaoImpl implements EmployeeActivityPlanRecordDao {

    @Autowired
    EmployeeActivityPlanRecordMapper employeeActivityPlanRecordMapper;

    @Override
    public Long save(EmployeeActivityPlanRecordDto planDto) {
        ActivityPlanRecordWrapper rWrapper = new ActivityPlanRecordWrapper()
                .setEmployeeId(planDto.getEmployeeId());
        LambdaQueryWrapper<EmployeeActivityPlanRecordDO> qw = buildWrapper(rWrapper);
        Integer count = employeeActivityPlanRecordMapper.selectCount(qw);
        if (count >= 1) {
            throw new DataException(RCode.ACTIVITY_PLAN_MONTH_HAS);
        }

        EmployeeActivityPlanRecordDO planDo = new EmployeeActivityPlanRecordDO();
        BeanUtils.copyProperties(planDto, planDo);
        employeeActivityPlanRecordMapper.insert(planDo);
        return planDo.getId();
    }

    @Override
    public void selectPage(ActivityPlanRecordWrapper wrap, PageInfo pageInfo) {
        LambdaQueryWrapper<EmployeeActivityPlanRecordDO> qw = buildWrapper(wrap);
        Page<EmployeeActivityPlanRecordDO> page = new Page<>(pageInfo.getPageNum(),pageInfo.getPageSize());
        Page<EmployeeActivityPlanRecordDO> doPage = employeeActivityPlanRecordMapper.selectPage(page, qw);
        pageInfo.pageCovert(doPage);
        pageInfo.setRecords(doPage.getRecords());
    }

    @Override
    public EmployeeActivityPlanRecordDto selectOne(ActivityPlanRecordWrapper wp) {
        LambdaQueryWrapper<EmployeeActivityPlanRecordDO> qw = buildWrapper(wp);
        EmployeeActivityPlanRecordDO planDo = employeeActivityPlanRecordMapper.selectOne(qw);
        return transitionDto(planDo);
    }

    @Override
    public void deleteById(Long id) {
        employeeActivityPlanRecordMapper.deleteByIdFake(id);
    }

    private LambdaQueryWrapper<EmployeeActivityPlanRecordDO> buildWrapper(ActivityPlanRecordWrapper rWrapper){
        LambdaQueryWrapper<EmployeeActivityPlanRecordDO> qw = new LambdaQueryWrapper<>();
        if (Objects.nonNull(rWrapper.getId())){
            qw.eq(EmployeeActivityPlanRecordDO::getId,rWrapper.getId());
            return qw;
        }

        if (Objects.nonNull(rWrapper.getEmployeeId())){
            qw.eq(EmployeeActivityPlanRecordDO::getEmployeeId,rWrapper.getEmployeeId());
        }

//        if (StringUtils.isNotBlank(rWrapper.getActivityMonth())){
//            qw.eq(EmployeeActivityPlanRecordDO::getActivityMonth,rWrapper.getActivityMonth());
//        }

        qw.eq(EmployeeActivityPlanRecordDO::getIsDelete, StatusType.VALID.getType());
        qw.orderByDesc(EmployeeActivityPlanRecordDO::getId);
        return qw;
    }


    /**
     * DO to DTO (单个对象)
     * @param planRecordDos DO对象List
     * @return DTO对象
     */
    private List<EmployeeActivityPlanRecordDto> transitionDtos(List<EmployeeActivityPlanRecordDO> planRecordDos) {
        if (CollectionUtils.isEmpty(planRecordDos)) {
            return new ArrayList<>();
        }

        List<EmployeeActivityPlanRecordDto> dtos = new ArrayList<>(planRecordDos.size() * 2);
        for (EmployeeActivityPlanRecordDO planRecordDo : planRecordDos) {
            dtos.add(transitionDto(planRecordDo));
        }
        return dtos;
    }

    private EmployeeActivityPlanRecordDto transitionDto(EmployeeActivityPlanRecordDO planRecordDo) {
        EmployeeActivityPlanRecordDto dto = null;
        if (Objects.isNull(planRecordDo)) {
            return dto;
        }
        dto = new EmployeeActivityPlanRecordDto();
        BeanUtils.copyProperties(planRecordDo, dto);
        return dto;
    }

}