package com.wangxiaolu.promotion.controller.activity.manage.tem;

import com.wangxiaolu.promotion.enums.activity.TemActApproveStatus;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.activity.manage.vo.ApproveVo;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.activity.manage.EmployeeCoreTemActivityService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author : liqiulin
 * @date : 2024-06-03 14
 * @describe : 员工操作审批 - 当前未使用此功能，当前逻辑：数据上报默认审批通过，无需人工审核
 */
@Slf4j
@RestController
@RequestMapping("/activity/employee/core")
public class EmployeeCoreTemActivityController {

    @Autowired
    EmployeeCoreTemActivityService employeeCoreTemActivityService;

    /**
     * 管理员审批上报活动数据
     */
//    @PostMapping("/approve/{id}")
    public R approveActivity(@PathVariable("id") long reportedId,@RequestBody ApproveVo approveVO) {
        if (TemActApproveStatus.SEND_BACK.equals(approveVO.getApproveStatus()) && StringUtils.isBlank(approveVO.getApproveReason())){
            throw new ParamException(RCode.SEND_BACK_REASON_NOT,null);
        }
        employeeCoreTemActivityService.approveActivity(reportedId,approveVO);
        return R.success();
    }

    /**
     * 管理员删除活动记录
     */
    @DeleteMapping("/delete/{id}")
    public R deleteActivityById(@PathVariable("id") long id){
        employeeCoreTemActivityService.deleteById(id);
        return R.success();
    }


}
