package com.wangxiaolu.promotion.controller.activity.temporary;

import com.wangxiaolu.promotion.exception.DataException;
import com.wangxiaolu.promotion.pojo.PageInfo;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.TemporaryActivityReportedDto;
import com.wangxiaolu.promotion.result.basedata.R;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.activity.temporary.TemporaryActivityQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-18 13
 * @describe : 促销员活动上报数据查询
 */
@Slf4j
@RestController
@RequestMapping("/activity/temporary/query")
public class TemporaryActivityQueryController {

    @Autowired
    private TemporaryActivityQueryService temporaryActivityQueryService;

    /**
     * 根据促销员id查询所有任务
     *
     * @return 所有任务（分页查询）
     */
    @PostMapping("/all/{temporary_id}")
    public R findtemporaryIdActivityDataList(@PathVariable("temporary_id") @NotNull Long temporaryId, @RequestBody PageInfo pageInfo) {
        temporaryActivityQueryService.findtemporaryIdActivityDataList(temporaryId, pageInfo);
        return R.success(pageInfo);
    }

    /**
     * 根据促销员id查询今日任务
     */
    @GetMapping("/today/{temporary_id}")
    public R findTemporaryTodayActivityData(@PathVariable("temporary_id") @NotNull Long temporaryId) {
        TemporaryActivityReportedDto dto = temporaryActivityQueryService.findtemporaryIdTodayActivityData(temporaryId);
        return R.success(dto);
    }

    /**
     * 根据任务id查询
     */
    @GetMapping("/{id}")
    public R findTemporaryActivityById(@PathVariable("id") @NotNull Long activityId) {
        TemporaryActivityReportedDto dto = temporaryActivityQueryService.findTemporaryActivityById(activityId);
        return R.success(dto);
    }

    /**
     * 促销员[今日活动 - （出售列表中添加）出售单元]数据
     * 数据暂存到redis中，当调用保存接口时再添加到数据库中
     */
    @GetMapping("/today/reported/market_cell")
    public R todayActivityMarketCell(Integer temporaryId) {
        return R.success(temporaryActivityQueryService.findActivityMarketCell(temporaryId));
    }

    /**
     * 促销员[今日活动 - （出售列表中添加）出售单元]数据
     * 返回保存在数据库中的数据
     */
    @GetMapping("/today/reported/market_cell/{id}")
    public R findActivityMarketCellByDb(@PathVariable("id") Long activityId) {
        if (Objects.isNull(activityId) || (activityId <= 0)) {
            return R.success();
        }
        return R.success(temporaryActivityQueryService.findActivityMarketCellByDb(activityId));
    }


    /**
     * 查询销售数据是否满足提交审批的条件
     * @return
     */
    @GetMapping("/today/approved_verify/{id}")
    public R findActivityApprovedVerify(@PathVariable("id") Long activityId){
        TemporaryActivityReportedDto activityReportedDto = temporaryActivityQueryService.findTemporaryActivityById(activityId);

        if (CollectionUtils.isEmpty(activityReportedDto.getTgscPhotoInfos()) || activityReportedDto.getTgscPhotoInfos().size() < 3){
            throw new DataException(RCode.NOT_TGSH_PHOTO_ERROR);
        }else if (CollectionUtils.isEmpty(activityReportedDto.getTghdPhotoInfos()) || activityReportedDto.getTghdPhotoInfos().size() < 3){
            throw new DataException(RCode.NOT_TGHD_PHOTO_ERROR);
        }else if (CollectionUtils.isEmpty(activityReportedDto.getTgcjPhotoInfos()) || activityReportedDto.getTgcjPhotoInfos().size() < 3){
            throw new DataException(RCode.NOT_TGCJ_PHOTO_ERROR);
        }
        return R.success();
    }
}
