package com.wangxiaolu.promotion.domain.user.dao.impl;

import com.alibaba.druid.util.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.wangxiaolu.promotion.domain.user.dao.TemporaryInfoDao;
import com.wangxiaolu.promotion.domain.user.mapper.TemporaryInfoMapper;
import com.wangxiaolu.promotion.domain.user.mapper.entity.TemporaryInfoDO;
import com.wangxiaolu.promotion.domain.user.wrapper.TemporaryWrapper;
import com.wangxiaolu.promotion.pojo.user.dto.WxTemporaryInfoDto;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-08 16
 * @describe :促销员-信息
 */
@Service
public class TemporaryInfoDaoImpl implements TemporaryInfoDao {

    @Autowired
    TemporaryInfoMapper temporaryInfoMapper;

    /**
     * 微信-小程序注册的促销员信息
     */
    @Override
    public int saveWxTemporaryInfo(WxTemporaryInfoDto temporaryDto){
        TemporaryInfoDO entity = new TemporaryInfoDO();
        BeanUtils.copyProperties(temporaryDto, entity);
        return temporaryInfoMapper.insert(entity);
    }

    @Override
    public WxTemporaryInfoDto getUnimportantData(String openId) {
        TemporaryInfoDO temDo = temporaryInfoMapper.getUnimportantData(openId);
        return transitionDto(temDo);
    }

    @Override
    public WxTemporaryInfoDto getUnimportantData(String openId, String phone) {
        TemporaryWrapper tw = new TemporaryWrapper().setOpenId(openId).setPhone(phone);
        LambdaQueryWrapper<TemporaryInfoDO> doqwer = buildQueryList(tw);
        TemporaryInfoDO temDo = temporaryInfoMapper.selectOne(doqwer);
        return transitionDto(temDo);
    }

    private LambdaQueryWrapper<TemporaryInfoDO> buildQueryList(TemporaryWrapper tw){
        LambdaQueryWrapper<TemporaryInfoDO> queryWrapper = new LambdaQueryWrapper<>();
        if (!StringUtils.isEmpty(tw.getOpenId())){
            queryWrapper.eq(TemporaryInfoDO::getOpenId,tw.getOpenId());
        }
        if (!StringUtils.isEmpty(tw.getPhone())){
            queryWrapper.eq(TemporaryInfoDO::getPhone,tw.getPhone());
        }
        return queryWrapper;
    }

    /**
     * DO to DTO (单个对象)
     * @param temDo DO对象
     * @return DTO对象
     */
    private WxTemporaryInfoDto transitionDto(TemporaryInfoDO temDo){
        WxTemporaryInfoDto temporaryDto = null;
        if (!Objects.isNull(temDo)){
            temporaryDto = new WxTemporaryInfoDto();
            BeanUtils.copyProperties(temDo, temporaryDto);
        }
        return temporaryDto;
    }
}
