package com.wangxiaolu.promotion.service.wechat.impl;

import com.alibaba.fastjson.JSONObject;
import com.wangxiaolu.promotion.domain.user.dao.QinCeEmployeeDao;
import com.wangxiaolu.promotion.domain.user.dao.TemporaryInfoDao;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.QinCeEmployeeDto;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.WxTemporaryInfoDelayDtO;
import com.wangxiaolu.promotion.pojo.user.dto.WxTemporaryInfoDto;
import com.wangxiaolu.promotion.result.basedata.RCode;
import com.wangxiaolu.promotion.service.user.WxTemporaryInfoDelayService;
import com.wangxiaolu.promotion.service.wechat.WeChatUserCoreService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-08 16
 * @describe :微信用户信息操作
 */
@Slf4j
@Service
public class WeChatUserCoreServiceImpl implements WeChatUserCoreService {

    @Autowired
    TemporaryInfoDao temporaryInfoDao;

    @Autowired
    QinCeEmployeeDao qinCeEmployeeDao;

    @Autowired
    private WxTemporaryInfoDelayService wxTemporaryInfoDelayService;

    /**
     * 保存促销员用户信息
     */
    @Override
    public boolean saveWxUserInfoTemporary(WxTemporaryInfoDto temporaryDto) {
        int saveId = temporaryInfoDao.saveWxTemporaryInfo(temporaryDto);
        log.info("微信-促销员[{}]:[{}]注册成功：{}", saveId, temporaryDto.getName(), JSONObject.toJSONString(temporaryDto));
        return saveId > 0;
    }

    /**
     * 保存用户门店信息
     * @param temporaryDto
     * @return
     */
    @Override
    public boolean saveWxUserStoreInfoTemporary(WxTemporaryInfoDto temporaryDto) {
        WxTemporaryInfoDto wxTemporaryInfoDto = temporaryInfoDao.selectOneByOpenId(temporaryDto.getOpenId());
        wxTemporaryInfoDto.setStoreCode(temporaryDto.getStoreCode());
        wxTemporaryInfoDto.setStoreName(temporaryDto.getStoreName());
        int saveId = temporaryInfoDao.saveWxUserStoreInfoTemporary(wxTemporaryInfoDto);
        return saveId > 0;
    }

    @Override
    public boolean batchSaveWxUserStoreInfo(List<WxTemporaryInfoDto> list) {
        // 调用DAO批量插入/更新（含storeCode/dataDate）
        return temporaryInfoDao.batchInsertOrUpdate(list) > 0;
    }

    @Override
    public boolean saveDelayData(WxTemporaryInfoDelayDtO delayEntity) {
        return wxTemporaryInfoDelayService.saveDelayData(delayEntity);
    }
}
