package com.wangxiaolu.promotion.service.user;

import com.wangxiaolu.promotion.domain.user.mapper.entity.WxTemporaryInfoDelayDO;
import com.wangxiaolu.promotion.pojo.activity.temporary.dto.WxTemporaryInfoDelayDtO;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 延迟临时表Service（适配前端入参字段）
 */
public interface WxTemporaryInfoDelayService {
    /**
     * 保存延迟数据到临时表（含storeCode/dataDate）
     */
    boolean saveDelayData(WxTemporaryInfoDelayDtO delayEntity);

    /**
     * 查询指定时间范围未处理的数据
     */
    List<WxTemporaryInfoDelayDtO> listUnprocessedData(LocalDateTime startTime, LocalDateTime endTime);

    /**
     * 批量更新处理状态
     */
    boolean batchUpdateProcessedStatus(List<Long> idList, Integer isProcessed);
}