package com.wangxiaolu.promotion.utils;

import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/**
 * @author : liqiulin
 * @date : 2024-03-29 18
 * @describe : 勤策 api请求配置
 */
@Component
@Slf4j
public class QinCeUtils {

    /**
     * =================== 勤策API - config ===================
     */
    @Value("${qince.open_api}")
    private String OPEN_API;
    @Value("${qince.open_id}")
    private String OPEN_ID;
    @Value("${qince.app_key}")
    private String APP_KEY;


    /**
     * =================== 勤策API - path ===================
     */
    // 部门、组织架构
    public static final String QUERY_ORGANIZATION = "/api/organization/v1/queryOrganization/";
    // 员工列表
    public static final String QUERY_EMPLOYEE = "/api/employee/v3/queryEmployee/";
    // 终端（商店）列表
    public static final String QUERY_SHORE = "/api/store/v1/queryStore/";

    public String builderUrl(String sidepath, Map<String, Object> params) {
        String msgId = UUID.randomUUID().toString();
        Long currentTimeMillis = System.currentTimeMillis();

        String digest = getDigest(params, currentTimeMillis);
        StringBuilder builder = new StringBuilder().append(OPEN_API).append(sidepath).append(OPEN_ID).append("/").append(currentTimeMillis).append("/").append(digest).append("/").append(msgId);
        return builder.toString();
    }

    /**
     * 查询[部门]参数
     */
    public Map<String, Object> queryOrgParam() {
        Map<String, Object> params = new HashMap<>();
        params.put("id", "");
        params.put("org_id", "");
        params.put("org_code", "");
        params.put("org_name", "");
        params.put("org_status", "");
        params.put("create_date", "");
        params.put("modify_date", "");
        return params;
    }

    /**
     * 查询[人员]参数
     */
    public Map<String, Object> queryEmployeeParam(boolean queryId) {
        Map<String, Object> params = new HashMap<>();
        // 根据来源勤策的员工唯一标识精确查询
        if (queryId) {
            params.put("id", "");
        }

        // 根据来源第三方系统的员工唯一标识精确查询，id、emp_id如果同时存在优先取id
        params.put("emp_id", "");
        // 根据员工登录帐号精确查询
        params.put("emp_code", "");
        // 根据姓名模糊查询
        params.put("emp_name", "");
        // 根据人员编码精确查询
        params.put("employee_code", "");
        // 根据员工状态查询
        params.put("emp_status", "");
        // 根据创建日期查询用户。格式：yyyy-MM-dd
        params.put("create_date", "");
        // 根据修改日期查询用户。格式：yyyy-MM-dd
        params.put("modify_date", "");
        // 根据手机号查询
        params.put("emp_mobile", "");
        return params;
    }

    /**
     * 查询[客户管理-终端]参数
     */
    public Map<String, Object> queryShopParam(Integer pageNum) {
        HashMap<String, Object> params = new HashMap<>();
        // 分页页码，默认1
        params.put("page_number", pageNum);
        // 记录状态。0：已删除，1：正常
        // 0：已删除:客户回收站中的终端数据
        params.put("status", "");
        // 勤策的门店唯一ID
        params.put("id", "");
        // 来源于第三方系统的门店唯一ID，对应新增门店 (store_id)字段，只有当数据来源于新增接口时才有值，如果数据从勤策系统中直接创建则该字段值为空。 如果两个值同时存在则优先顺序为store_waiqin_id、store_id
        params.put("store_id", "");
        // 门店名称，唯一
        params.put("store_name", "");
        // 门店编码
        params.put("store_code", "");
        // 根据门店客户经理标识查询
        params.put("store_manager_id", "");
        // 门店类型编码，store_type、store_type_code如果同时存在优先取store_type_code
        params.put("store_type_code", "");
        // 门店类型
        params.put("store_type", "");
        // 门店所属销售区域，此字段需要销售区域的完整层级结构， 多层级间以“,”分隔，如：华中大区,南京分区,秦淮社区
        params.put("store_district", "");
        return params;
    }

    private String getDigest(Map<String, Object> params, Long currentTimeMillis) {
        String json = "";
        if (!CollectionUtils.isEmpty(params)) {
            json = JSONObject.toJSONString(params);
        }
        String digest = DigestUtils.md5Hex(json + "|" + APP_KEY + "|" + currentTimeMillis);
        return digest;
    }

}
