package com.wangxiaolu.promotion.pojo.activity.temporary.vo;

import com.wangxiaolu.promotion.enums.activity.ActivityPhotoType;
import com.wangxiaolu.promotion.enums.activity.ClockType;
import com.wangxiaolu.promotion.exception.ParamException;
import com.wangxiaolu.promotion.result.basedata.RCode;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.Objects;

/**
 * @author : liqiulin
 * @date : 2024-04-23 13
 * @describe : 促销员打卡数据模型
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Accessors(chain = true)
public class TemporaryClockVo {
    /**
     * 打卡记录id
     */
    Long id;

    /**
     * 打卡类型：1、上班卡；2、午休下班卡；3、午休上班卡；4、下班卡
     */
    Integer clockType;

    /**
     * temporaryId
     */
    Long temporaryId;

    String temporaryName;

    /**
     * 促销计划ID
     */
    Long planId;

    // 店铺id - 活动计划中的id
    Long storeId;

    // 店铺名称
    String storeName;

    // 上班打卡地点
    String clockAddress;

    // 上班打卡经纬度
    String clockCoordinates;

    // 上班打卡图片
    String clockPhoto;

    // 打卡省
    String clockProvince;

    // 打卡城市
    String clockCity;

    // 活动模式Id
//    Integer activityPatternId;
//
//    // 活动模式
//    String activityPattern;

    /**
     * 修改时用到，上次打卡时间
     */
    Date lastClockTime;


    public void validate(){
        if (Objects.isNull(clockType) || !(clockType >= 1 && clockType <= 4)){
            throw new ParamException(RCode.CLOCK_DETAIL_ERROR, null);
        }
        if (Objects.isNull(temporaryId)){
            throw new ParamException(RCode.LOGIN_PARAM_ERROR, null);
        }
        if (StringUtils.isBlank(clockAddress)){
            throw new ParamException(RCode.NOT_ADDRESS_ERROR, null);
        }
        if (StringUtils.isBlank(clockPhoto)){
            throw new ParamException(RCode.NOT_CLOCK_PHOTO_ERROR, null);
        }
    }

    public Integer getPhotoType() {
        if (ClockType.TEMPORARY_CLOCK_IN.equals(clockType)) {
            return ActivityPhotoType.CLOCK_IN.getType();
        } else if (ClockType.TEMPORARY_NOON_CLOCK_OUT.equals(clockType)) {
            return ActivityPhotoType.NOON_CLOCK_OUT.getType();
        } else if (ClockType.TEMPORARY_NOON_CLOCK_IN.equals(clockType)) {
            return ActivityPhotoType.NOON_CLOCK_IN.getType();
        } else if (ClockType.TEMPORARY_CLOCK_OUT.equals(clockType)) {
            return ActivityPhotoType.CLOCK_OUT.getType();
        }
        throw new ParamException(RCode.PHOTO_IS_NULL_ERROR, null);
    }
}
