package com.wangxiaolu.promotion.pojo.activity.inspectionInfo.vo;

import com.alibaba.fastjson2.JSONArray;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author: DouXinYu
 * @Date: 2026-01-08 17:14
 * @Description: 稽核信息 V2.0 临时接收信息表
 */

@Data
public class InspectionInfoVO {
    /**
     * 当前稽核ID
     */
    private Long id;

    /**
     * 当前门店对应的计划
     */
    private Long planId;

    /**
     * 稽查店铺的日期
     */
    private Date inspectionDate;

    /**
     * 开始稽查的具体时间
     */
    private String inspectionTime;

    /**
     * 结束稽查离开店铺的时间
     */
    private String leaveStoreTime;

    /**
     * 促销员是否在岗的状态（是/否）
     */
    private String onDutyStatus;

    /**
     * 促销员的在岗率（百分比）
     */
    private BigDecimal onDutyRate;

    /**
     * 实际在岗的促销人员数量
     */
    private Integer onDutyCount;

    /**
     * 促销员当前是否在岗（是/否）
     */
    private String isOnDuty;

    /**
     * 促销员未在岗时电话拨出的时间
     */
    private String offDutyCallTime;

    /**
     * 电话是否接通（是/否）
     */
    private String isCallConnected;

    /**
     * 5分钟后再次拨打电话是否接通（是/否）
     */
    private String isReconnectedAfter5min;

    /**
     * 10分钟内是否返回岗位（是/否）
     */
    private String isBackToWorkWithin10min;

    /**
     * 本次稽查的总得分
     */
    private Integer totalScore;

    /**
     * 销售相关考核得分（满分50分）
     */
    private Integer salesAssessmentScore;

    /**
     * 促销相关考核得分（满分50分）
     */
    private Integer promotionAssessmentScore;

    /**
     * 是否有档期或特价活动得分（满分20分）
     */
    private Integer hasSchedulePromotionScore;

    /**
     * 地堆上是否陈列主推产品得分（满分8分）
     */
    private Integer groundStackHasMainProductScore;

    /**
     * 地堆上是否只陈列王小卤产品得分（满分8分）
     */
    private Integer groundStackOnlyWangxiaoluScore;

    /**
     * 地堆铺货是否饱满得分（满分4分）
     */
    private Integer groundStackStockFullScore;

    /**
     * 是否配备各类宣传物料得分（满分10分）
     */
    private Integer hasPromotionMaterialsScore;

    /**
     * 是否穿着王小卤品牌围裙得分（满分3分）
     */
    private Integer wearsWangxiaoluApronScore;

    /**
     * 是否准备试吃品得分（满分5分）
     */
    private Integer hasTastingProductScore;

    /**
     * 是否设置试吃台得分（满分3分）
     */
    private Integer hasTastingTableScore;

    /**
     * 是否准备试吃盘得分（满分3分）
     */
    private Integer hasTastingPlateScore;

    /**
     * 是否准备试吃杯得分（满分3分）
     */
    private Integer hasTastingCupScore;

    /**
     * 是否佩戴口罩和手套得分（满分3分）
     */
    private Integer wearsMaskGlovesScore;

    /**
     * 是否提供牙签加分（满分2分）
     */
    private Integer hasToothpickBonusScore;

    /**
     * 是否配备垃圾桶加分（满分2分）
     */
    private Integer hasGarbageCanBonusScore;

    /**
     * 是否知晓远距离招揽话术得分（满分5分）
     */
    private Integer knowsDistanceSolicitSkillScore;

    /**
     * 是否知晓黑鸭或卤香产品卖点得分（满分5分）
     */
    private Integer knowsProductSellingPointsScore;

    /**
     * 人流经过时是否主动迎接得分（满分5分）
     */
    private Integer greetsCustomersActivelyScore;

    /**
     * 是否讲解产品卖点推荐产品得分（满分3分）
     */
    private Integer introducesProductScoresScore;

    /**
     * 是否有促进销售的动作得分（满分2分）
     */
    private Integer promotesSalesActivelyScore;

    /**
     * 是否配置活动赠品得分（满分5分）
     */
    private Integer hasPromotionGiftsScore;

    /**
     * 是否主动销售非王小卤产品得分（满分5分）
     */
    private Integer sellsNonWangxiaoluProductsScore;

    /**
     * 促销活动的具体内容描述
     */
    private String promotionActivityContent;

    /**
     * 是否设置了地堆陈列（是/否）
     */
    private String hasGroundStack;

    /**
     * 是否有黑鸭产品陈列（是/否）
     */
    private String hasBlackDuckDisplay;

    /**
     * 是否有黑鸭产品试吃品（是/否）
     */
    private String hasBlackDuckTasting;

    /**
     * 其他品牌是否设置了试吃台（是/否）
     */
    private String otherBrandHasTastingTable;

    /**
     * 10分钟内经过促销人员的人流数量
     */
    private BigDecimal pedestrianCountWithin10min;

    /**
     * 试吃品的总数量
     */
    private BigDecimal totalTastingProductCount;

    /**
     * 按口味统计的试吃品数量
     */
    private String tastingProductCountByFlavor;

    /**
     * 其他品牌试吃台的佐证照片链接
     */
    private String otherBrandTastingTableProofUrl;

    /**
     * 销售非王小卤产品的佐证照片链接
     */
    private String nonWangxiaoluSalesProofUrl;

    /**
     * 门头照
     */
    private String storePicture;

    /**
     * 促销员在岗/离岗佐证照
     */
    private JSONArray temWorkPhotos;

    /**
     * 特殊陈列照片
     */
    private String storeTcPhoto;

    /**
     * 主货架照片
     */
    private String storeZhiPhoto;
}
